/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.actions;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.vdb.VdbConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;
import org.teiid.designer.ui.viewsupport.SingleProjectFilter;

public class EditVdbAction
extends Action
implements VdbConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(EditVdbAction.class);
    Properties designerProperties;

    public EditVdbAction() {
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/edit-vdb.gif"));
        this.setToolTipText(DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "tooltip", new Object[0]));
    }

    public EditVdbAction(Properties properties) {
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/edit-vdb.gif"));
        this.setToolTipText(DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "tooltip", new Object[0]));
        this.designerProperties = properties;
    }

    public void run() {
        IResource theVdb = DesignerPropertiesUtil.getVDB((Properties)this.designerProperties);
        IFile selectedVdb = null;
        if (theVdb != null) {
            selectedVdb = (IFile)theVdb;
        }
        if (selectedVdb == null) {
            ModelWorkspaceDialog vdbDialog = this.getSelectVdbDialog();
            vdbDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
            vdbDialog.open();
            if (vdbDialog.getReturnCode() == 0) {
                Object[] selections = vdbDialog.getResult();
                selectedVdb = (IFile)selections[0];
            }
        }
        if (selectedVdb != null) {
            try {
                IDE.openEditor((IWorkbenchPage)UiUtil.getWorkbenchPage(), (IFile)selectedVdb, (boolean)true);
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
            }
        }
    }

    private ModelWorkspaceDialog getSelectVdbDialog() {
        ModelWorkspaceDialog selectVdbDialog = new ModelWorkspaceDialog(UiUtil.getWorkbenchShellOnlyIfUiThread(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        selectVdbDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        selectVdbDialog.addFilter((ViewerFilter)new SingleProjectFilter(this.designerProperties));
        String title = DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.title", new Object[0]);
        String message = DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.message", new Object[0]);
        selectVdbDialog.setTitle(title);
        selectVdbDialog.setMessage(message);
        selectVdbDialog.setAllowMultiple(false);
        selectVdbDialog.setInput((Object)ModelerCore.getWorkspace().getRoot());
        selectVdbDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                String extension;
                if (selection != null && selection.length == 1 && selection[0] instanceof IFile && (extension = ((IFile)selection[0]).getFileExtension()) != null && extension.equals("vdb")) {
                    return new StatusInfo("org.teiid.designer.dqp.ui");
                }
                if (selection == null || selection.length == 0) {
                    return new StatusInfo("org.teiid.designer.dqp.ui", 4, DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.emptySelection", new Object[0]));
                }
                String msg = DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.invalidSelection", new Object[0]);
                return new StatusInfo("org.teiid.designer.dqp.ui", 4, msg);
            }
        });
        return selectVdbDialog;
    }
}

