/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.actions;

import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDeploymentInfoDialog;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.vdb.VdbUtil;

public class GenerateWarAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    protected static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(GenerateWarAction.class);
    protected static final String VDB_EXTENSION = "vdb";
    protected boolean successfulRefresh = false;
    IFile selectedVDB;
    boolean contextIsLocal = false;

    public GenerateWarAction() {
        this.setText(DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "text", new Object[0]));
        this.setToolTipText(DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "tooltip", new Object[0]));
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deployVdb.png"));
        this.setDisabledImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deployVdb.png"));
        this.setEnabled(false);
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    public boolean isApplicable(ISelection selection) {
        String extension;
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IFile && (extension = ((IFile)obj).getFileExtension()) != null && extension.equals(VDB_EXTENSION)) {
            result = true;
        }
        return result;
    }

    public void run() {
        boolean wasSuccessful;
        final IWorkbenchWindow window = DqpUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        boolean cont = true;
        if (compiler == null) {
            cont = MessageDialog.openConfirm((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "javaWarningTitle", new Object[0]), (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "invalidJDKMessage", new Object[0]));
        }
        if (!cont) {
            this.notifyResult(false);
            return;
        }
        WarDeploymentInfoDialog dialog = new WarDeploymentInfoDialog(window.getShell(), this.selectedVDB, null);
        int rc = dialog.open();
        String warFileName = dialog.getWarFileName();
        final String successMessage = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "warFileCreated", (Object)warFileName);
        boolean bl = wasSuccessful = rc == 0;
        if (wasSuccessful) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "creationCompleteTitle", new Object[0]), (String)successMessage);
                }
            });
        } else if (rc != 1) {
            MessageDialog.openError((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "creationFailedTitle", new Object[0]), (String)dialog.getMessage());
        }
        this.notifyResult(rc == 0);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String extension;
        Object obj;
        boolean enable = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IFile && (extension = ((IFile)obj).getFileExtension()) != null && extension.equals(VDB_EXTENSION)) {
            this.selectedVDB = (IFile)obj;
            try {
                if (VdbUtil.hasModelClass((IFile)this.selectedVDB, (String)"Web Service", (String)ModelType.VIRTUAL_LITERAL.getLiteral())) {
                    enable = true;
                }
            }
            catch (Exception ex) {
                DqpUiConstants.UTIL.log((Throwable)ex);
            }
        }
        this.setEnabled(enable);
    }
}

