/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.datatools.ui.dialogs.ConnectionProfileWorker;
import org.teiid.designer.datatools.ui.dialogs.IProfileChangedListener;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.connection.TeiidDataSourceInfo;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.ScrollableTitleAreaDialog;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class CreateDataSourceWizard
extends ScrollableTitleAreaDialog
implements IProfileChangedListener {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(CreateDataSourceWizard.class);
    private static final String TITLE = CreateDataSourceWizard.getString("title");
    private static final String DEFAULT_NAME = CreateDataSourceWizard.getString("defaultName");
    private static final String PASSWORD = CreateDataSourceWizard.getString("passwordStr");
    private static final String HIDDEN_PASSWORD = "********";
    private static final String NEW_BUTTON = DqpUiConstants.UTIL.getString("Button.newLabel", new Object[0]);
    private static final String EDIT_BUTTON = DqpUiConstants.UTIL.getString("Button.editLabel", new Object[0]);
    private static final String JNDI_PREFIX = "java:/";
    private ModelResource selectedModelResource;
    String dataSourceName;
    Combo modelsCombo;
    Button useModelCheckBox;
    Combo connectionProfilesCombo;
    Button useConnectionProfileCheckBox;
    private Button newCPButton;
    private Button editCPButton;
    private ILabelProvider profileLabelProvider;
    Text dataSourceNameText;
    TableViewer propsViewer;
    private TableContentProvider propertiesContentProvider;
    Map<String, ModelResource> relationalModelsMap = new HashMap<String, ModelResource>();
    private ITeiidServer teiidServer;
    private ConnectionInfoProviderFactory providerFactory;
    private StringNameValidator dataSourceNameValidator;
    boolean hasModelResources = false;
    private Properties teiidDataSourceProperties;
    private IConnectionInfoProvider currentProvider;
    ConnectionProfileWorker profileWorker;
    private boolean connRequiresPassword = false;

    private static String getString(String id) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object value) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, value);
    }

    public CreateDataSourceWizard(Shell shell, ITeiidServer teiidServer, Collection<ModelResource> relationalModels, ModelResource initialSelection) {
        super(shell, 2);
        for (ModelResource mr : relationalModels) {
            this.relationalModelsMap.put(ModelUtil.getName((ModelResource)mr), mr);
        }
        this.hasModelResources = !this.relationalModelsMap.isEmpty();
        this.teiidServer = teiidServer;
        this.selectedModelResource = initialSelection;
        this.providerFactory = new ConnectionInfoProviderFactory();
        this.teiidDataSourceProperties = new Properties();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE);
        this.setTitleImage(UiPlugin.getDefault().getImage("icons/full/wizban/importTeiidMetadataWiz.gif"));
        this.setMessage("Create and Deploy a Data Source");
        this.profileWorker = new ConnectionProfileWorker(this.getShell(), null, (IProfileChangedListener)this);
        Composite mainPanel = (Composite)super.createDialogArea(parent);
        ((GridLayout)mainPanel.getLayout()).marginTop = 5;
        ((GridLayout)mainPanel.getLayout()).marginBottom = 10;
        ((GridLayout)mainPanel.getLayout()).verticalSpacing = 8;
        WidgetFactory.createLabel((Composite)mainPanel, (String)CreateDataSourceWizard.getString("teiidServer.label"));
        if (StringUtilities.isEmpty((String)this.teiidServer.getCustomLabel())) {
            WidgetFactory.createLabel((Composite)mainPanel, (int)768, (int)1, (String)this.teiidServer.getUrl());
        } else {
            WidgetFactory.createLabel((Composite)mainPanel, (int)768, (int)1, (String)this.teiidServer.getCustomLabel());
        }
        WidgetFactory.createLabel((Composite)mainPanel, (String)CreateDataSourceWizard.getString("name.label"));
        this.dataSourceName = this.getDefaultDataSourceName();
        if (this.selectedModelResource != null) {
            ConnectionInfoHelper helper = new ConnectionInfoHelper();
            this.dataSourceName = helper.getJndiProperty(this.selectedModelResource);
            String nameOnly = "";
            if (!StringUtilities.isEmpty((String)this.dataSourceName)) {
                nameOnly = this.dataSourceName;
                if (this.dataSourceName.startsWith(JNDI_PREFIX)) {
                    nameOnly = this.dataSourceName.substring(6);
                }
                this.dataSourceName = nameOnly;
            }
            if (this.dataSourceName == null) {
                this.dataSourceName = ModelUtil.getName((ModelResource)this.selectedModelResource);
            }
        }
        this.dataSourceNameText = WidgetFactory.createTextField((Composite)mainPanel, (int)768, (int)1, (String)this.dataSourceName);
        this.dataSourceNameText.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        this.dataSourceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateDataSourceWizard.this.dataSourceName = CreateDataSourceWizard.this.dataSourceNameText.getText();
                CreateDataSourceWizard.this.validateInputs();
            }
        });
        Text helpText = new Text(mainPanel, 72);
        helpText.setBackground(Display.getCurrent().getSystemColor(19));
        helpText.setForeground(GlobalUiColorManager.NOTE_COLOR);
        helpText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)helpText.getLayoutData()).horizontalSpan = 2;
        helpText.setText(CreateDataSourceWizard.getString("dataSourceNameHelp.txt"));
        Group connectionSourceGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)CreateDataSourceWizard.getString("connectionSourceGroup.label"), (int)768, (int)2, (int)4);
        boolean useModelRes = this.selectedModelResource != null;
        this.useModelCheckBox = WidgetFactory.createRadioButton((Composite)connectionSourceGroup, (String)CreateDataSourceWizard.getString("useModelInfo.label"), (int)0, (int)4, (boolean)useModelRes);
        this.useModelCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (CreateDataSourceWizard.this.hasModelResources) {
                    CreateDataSourceWizard.this.resetComboBoxes();
                    CreateDataSourceWizard.this.useConnectionProfileCheckBox.setSelection(!CreateDataSourceWizard.this.useModelCheckBox.getSelection());
                    CreateDataSourceWizard.this.handleModelResourceSelection();
                    CreateDataSourceWizard.this.setConnectionProperties();
                    CreateDataSourceWizard.this.propsViewer.refresh();
                    CreateDataSourceWizard.this.validateInputs();
                }
            }
        });
        WidgetFactory.createLabel((Composite)connectionSourceGroup, (String)CreateDataSourceWizard.getString("model.label"));
        ArrayList<ModelResource> modelsList = new ArrayList<ModelResource>(this.relationalModelsMap.values());
        LabelProvider modelsLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ModelUtil.getName((ModelResource)((ModelResource)source));
            }

            public Image getImage(Object source) {
                return ModelIdentifier.getModelImage((ModelResource)((ModelResource)source));
            }
        };
        this.modelsCombo = useModelRes ? WidgetFactory.createCombo((Composite)connectionSourceGroup, (int)8, (int)832, modelsList, (Object)this.selectedModelResource, (ILabelProvider)modelsLabelProvider, (boolean)true) : WidgetFactory.createCombo((Composite)connectionSourceGroup, (int)8, (int)768, modelsList, (ILabelProvider)modelsLabelProvider, (boolean)true);
        this.modelsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (CreateDataSourceWizard.this.useModelCheckBox.getSelection()) {
                    CreateDataSourceWizard.this.handleModelResourceSelection();
                }
            }
        });
        this.modelsCombo.setVisibleItemCount(10);
        GridData modelsComboGD = new GridData(1808);
        modelsComboGD.horizontalSpan = 3;
        this.modelsCombo.setLayoutData((Object)modelsComboGD);
        this.useConnectionProfileCheckBox = WidgetFactory.createRadioButton((Composite)connectionSourceGroup, (String)CreateDataSourceWizard.getString("useProfileInfo.label"), (int)0, (int)4, (!useModelRes ? 1 : 0) != 0);
        this.useConnectionProfileCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateDataSourceWizard.this.resetComboBoxes();
                CreateDataSourceWizard.this.useModelCheckBox.setSelection(!CreateDataSourceWizard.this.useConnectionProfileCheckBox.getSelection());
                if (CreateDataSourceWizard.this.useConnectionProfileCheckBox.getSelection()) {
                    CreateDataSourceWizard.this.handleConnectionProfileSelected();
                }
                CreateDataSourceWizard.this.propsViewer.refresh();
                CreateDataSourceWizard.this.validateInputs();
            }
        });
        WidgetFactory.createLabel((Composite)connectionSourceGroup, (String)CreateDataSourceWizard.getString("connectionProfile.label"));
        this.profileLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ((IConnectionProfile)source).getName();
            }
        };
        this.connectionProfilesCombo = WidgetFactory.createCombo((Composite)connectionSourceGroup, (int)8, (int)768, (List)this.profileWorker.getProfiles(), (ILabelProvider)this.profileLabelProvider, (boolean)true);
        this.connectionProfilesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateDataSourceWizard.this.handleConnectionProfileSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.connectionProfilesCombo.setVisibleItemCount(10);
        this.newCPButton = WidgetFactory.createButton((Composite)connectionSourceGroup, (String)NEW_BUTTON);
        this.newCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateDataSourceWizard.this.profileWorker.create();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)connectionSourceGroup, (String)EDIT_BUTTON);
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateDataSourceWizard.this.profileWorker.edit();
            }
        });
        if (useModelRes) {
            this.useConnectionProfileCheckBox.setSelection(false);
            this.connectionProfilesCombo.setEnabled(false);
            this.modelsCombo.setEnabled(true);
        } else {
            this.useConnectionProfileCheckBox.setSelection(true);
            this.connectionProfilesCombo.setEnabled(true);
            this.modelsCombo.setEnabled(false);
        }
        Group propsGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)CreateDataSourceWizard.getString("connectionProperties.label"), (int)1808, (int)2, (int)2);
        GridData propertiesGridData = new GridData(1808);
        propertiesGridData.horizontalSpan = 2;
        propertiesGridData.heightHint = 180;
        propertiesGridData.minimumHeight = 180;
        propertiesGridData.grabExcessVerticalSpace = true;
        propsGroup.setLayoutData((Object)propertiesGridData);
        int tableStyle = 68352;
        this.propsViewer = new TableViewer((Composite)propsGroup, tableStyle);
        Table table = this.propsViewer.getTable();
        table.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(CreateDataSourceWizard.getString("property.name.label"));
        column1.setWidth(200);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(CreateDataSourceWizard.getString("property.value.label"));
        column2.setWidth(50);
        table.pack();
        GridData columnData = new GridData(1808);
        table.setLayoutData((Object)columnData);
        this.propertiesContentProvider = new TableContentProvider();
        this.propsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.propsViewer.setLabelProvider((IBaseLabelProvider)this.propertiesContentProvider);
        if (!this.hasModelResources) {
            this.useModelCheckBox.setEnabled(false);
            this.modelsCombo.setEnabled(false);
        }
        if (this.profileWorker.getProfiles().isEmpty()) {
            this.useConnectionProfileCheckBox.setEnabled(false);
            this.connectionProfilesCombo.setEnabled(false);
        } else {
            this.connectionProfilesCombo.select(0);
            this.handleConnectionProfileSelected();
        }
        if (this.profileWorker.getProfiles().isEmpty() && !this.hasModelResources) {
            this.setErrorMessage(CreateDataSourceWizard.getString("noConnectionDataError.message"));
        } else {
            this.setConnectionProperties();
        }
        this.sizeScrolledPanel();
        this.resetComboBoxes();
        return mainPanel;
    }

    private void resetComboBoxes() {
        this.connectionProfilesCombo.setEnabled(this.useConnectionProfileCheckBox.getSelection());
        this.modelsCombo.setEnabled(!this.useConnectionProfileCheckBox.getSelection());
        this.modelsCombo.setForeground(this.getColorForEnablement(this.modelsCombo.getEnabled()));
        this.connectionProfilesCombo.setForeground(this.getColorForEnablement(this.connectionProfilesCombo.getEnabled()));
    }

    private Color getColorForEnablement(boolean enabled) {
        if (enabled) {
            return GlobalUiColorManager.EMPHASIS_COLOR;
        }
        return GlobalUiColorManager.EMPHASIS_COLOR_DISABLED;
    }

    void handleModelResourceSelection() {
        if (this.modelsCombo.getSelectionIndex() >= 0) {
            String selectedItem = this.modelsCombo.getItem(this.modelsCombo.getSelectionIndex());
            this.selectedModelResource = this.relationalModelsMap.get(selectedItem);
        } else {
            this.selectedModelResource = null;
        }
        this.setConnectionProperties();
    }

    void handleConnectionProfileSelected() {
        String name;
        int selIndex = this.connectionProfilesCombo.getSelectionIndex();
        if (selIndex >= 0 && (name = this.connectionProfilesCombo.getItem(selIndex)) != null) {
            IConnectionProfile profile = this.profileWorker.getProfile(name);
            this.profileWorker.setSelection(profile);
            this.setConnectionProperties();
        }
    }

    public TeiidDataSourceInfo getTeiidDataSourceInfo() {
        TeiidDataSourceInfo info = new TeiidDataSourceInfo(this.dataSourceName, this.dataSourceName, this.teiidDataSourceProperties, this.currentProvider, this.connRequiresPassword);
        return info;
    }

    void validateInputs() {
        if (this.dataSourceName == null || this.dataSourceName.length() == 0) {
            this.setErrorMessage(CreateDataSourceWizard.getString("nullNameError.message"));
        } else if (this.useModelCheckBox != null && this.useModelCheckBox.getSelection() && this.teiidDataSourceProperties.isEmpty()) {
            this.setErrorMessage(CreateDataSourceWizard.getString("noValidTeiidPropertiesInModelError.message"));
        } else if (this.useConnectionProfileCheckBox != null && this.useConnectionProfileCheckBox.getSelection() && this.teiidDataSourceProperties.isEmpty()) {
            this.setErrorMessage(CreateDataSourceWizard.getString("noValidTeiidPropertiesError.message"));
        } else if (!this.isValidName(this.dataSourceName)) {
            String msg = this.checkValidName(this.dataSourceName);
            this.setErrorMessage(msg);
        } else if (this.nameExists(this.dataSourceName)) {
            this.setErrorMessage(CreateDataSourceWizard.getString("dataSourceExists.message", this.dataSourceName));
        } else {
            this.setErrorMessage(null);
            this.setMessage(CreateDataSourceWizard.getString("finish.message"));
        }
    }

    void setConnectionProperties() {
        IConnectionInfoProvider provider;
        Properties props = new Properties();
        this.currentProvider = null;
        if (this.useModelCheckBox.getSelection()) {
            if (this.selectedModelResource != null) {
                try {
                    provider = this.getProvider(this.selectedModelResource);
                    if (provider != null) {
                        this.currentProvider = provider;
                        IConnectionProfile modelCP = provider.getConnectionProfile(this.selectedModelResource);
                        props = provider.getTeiidRelatedProperties(modelCP);
                        this.connRequiresPassword = provider.requiresPassword(provider.getConnectionProfile(this.selectedModelResource));
                    }
                }
                catch (ModelWorkspaceException e) {
                    DqpUiConstants.UTIL.log((Throwable)e);
                }
                catch (Exception exception) {}
            }
        } else if (this.profileWorker.getConnectionProfile() != null) {
            try {
                provider = this.getProvider(this.profileWorker.getConnectionProfile());
                if (provider != null) {
                    this.currentProvider = provider;
                    props = provider.getTeiidRelatedProperties(this.profileWorker.getConnectionProfile());
                    this.connRequiresPassword = provider.requiresPassword(this.profileWorker.getConnectionProfile());
                }
            }
            catch (ModelWorkspaceException e) {
                DqpUiConstants.UTIL.log((Throwable)e);
            }
            catch (Exception e) {
                DqpUiConstants.UTIL.log((Throwable)e);
            }
        }
        if (props != null && !props.isEmpty()) {
            this.teiidDataSourceProperties = props;
            ArrayList<StringKeyValuePair> propsColl = new ArrayList<StringKeyValuePair>();
            for (Object key : props.keySet()) {
                String keyStr = (String)key;
                String value = props.getProperty((String)key);
                if (keyStr.equalsIgnoreCase(PASSWORD)) {
                    value = HIDDEN_PASSWORD;
                }
                propsColl.add(new StringKeyValuePair(keyStr, value));
            }
            this.propsViewer.setInput(propsColl);
        } else {
            this.teiidDataSourceProperties.clear();
            this.propsViewer.setInput(new ArrayList());
        }
        this.validateInputs();
    }

    private IConnectionInfoProvider getProvider(Object obj) throws Exception {
        IConnectionInfoProvider provider = null;
        if (obj instanceof ModelResource) {
            provider = this.providerFactory.getProvider((ModelResource)obj);
        } else if (obj instanceof IConnectionProfile) {
            provider = this.providerFactory.getProvider((IConnectionProfile)obj);
        }
        return provider;
    }

    private boolean nameExists(String name) {
        try {
            if (this.teiidServer.dataSourceExists(name)) {
                return true;
            }
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log((Throwable)e);
        }
        return false;
    }

    private String getDefaultDataSourceName() {
        int i = 1;
        String tempName = String.valueOf(DEFAULT_NAME) + i;
        if (this.nameExists(tempName)) {
            tempName = String.valueOf(DEFAULT_NAME) + ++i;
        }
        return tempName;
    }

    private String checkValidName(String name) {
        if (this.dataSourceNameValidator == null) {
            this.dataSourceNameValidator = new DataSourceNameValidator(1, 255);
        }
        return this.dataSourceNameValidator.checkValidName(name);
    }

    private boolean isValidName(String name) {
        if (this.dataSourceNameValidator == null) {
            this.dataSourceNameValidator = new DataSourceNameValidator(1, 255);
        }
        return this.dataSourceNameValidator.isValidName(name);
    }

    public void profileChanged(IConnectionProfile profile) {
        this.resetCPComboItems();
        this.selectConnectionProfile(profile.getName());
        this.setConnectionProperties();
    }

    void resetCPComboItems() {
        if (this.connectionProfilesCombo != null) {
            ArrayList<IConnectionProfile> profileList = new ArrayList<IConnectionProfile>();
            for (IConnectionProfile prof : this.profileWorker.getProfiles()) {
                profileList.add(prof);
            }
            WidgetUtil.setComboItems((Combo)this.connectionProfilesCombo, profileList, (ILabelProvider)this.profileLabelProvider, (boolean)true);
        }
    }

    void selectConnectionProfile(String name) {
        if (name == null) {
            return;
        }
        int cpIndex = -1;
        int i = 0;
        String[] stringArray = this.connectionProfilesCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                cpIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        if (cpIndex > -1) {
            this.connectionProfilesCombo.select(cpIndex);
        }
    }

    class DataSourceNameValidator
    extends StringNameValidator {
        public DataSourceNameValidator(int minLength, int maxLength) {
            super(minLength, maxLength, new char[]{'_', '-', '.'});
        }

        public String getValidNonLetterOrDigitMessageSuffix() {
            return DqpUiConstants.UTIL.getString("DataSourceNameValidator.or_other_valid_characters", new Object[0]);
        }
    }

    class StringKeyValuePair {
        private String key;
        private String value;

        public StringKeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    class TableContentProvider
    implements ITableLabelProvider {
        TableContentProvider() {
        }

        public Image getColumnImage(Object theElement, int theIndex) {
            return null;
        }

        public String getColumnText(Object theElement, int theColumnIndex) {
            if (theElement instanceof StringKeyValuePair) {
                StringKeyValuePair prop = (StringKeyValuePair)theElement;
                if (theColumnIndex == 0) {
                    return prop.getKey();
                }
                return prop.getValue();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

