/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.views.TeiidServerContentProvider;
import org.teiid.designer.runtime.ui.views.TeiidServerLabelProvider;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.MessageLabel;

public class SelectJndiDataSourceDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private static final String DEFAULT_TITLE = DqpUiConstants.UTIL.getString("SelectJndiDataSourceDialog.title", new Object[0]);
    private static final String DEFAULT_MESSAGE = DqpUiConstants.UTIL.getString("SelectJndiDataSourceDialog.defaultMessage", new Object[0]);
    private static final String UNDEFINED = DqpUiConstants.UTIL.getString("SelectJndiDataSourceDialog.undefined", new Object[0]);
    private Text dataSourceNameText;
    private MessageLabel statusMessageLabel;
    private ITeiidDataSource selectedDataSource;

    public SelectJndiDataSourceDialog(Shell parent) {
        super(parent, (ILabelProvider)new TeiidServerLabelProvider(), (ITreeContentProvider)new TeiidServerContentProvider(false, false, true));
        this.setTitle(DEFAULT_TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        this.setInput(DqpPlugin.getInstance().getServerManager());
        this.setAllowMultiple(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData panelData = new GridData(1808);
        panel.setLayoutData((Object)panelData);
        Group selectedGroup = WidgetFactory.createGroup((Composite)panel, (String)"Selected JNDI Data Source", (int)768, (int)1, (int)2);
        this.dataSourceNameText = WidgetFactory.createTextField((Composite)selectedGroup, (int)768, (String)UNDEFINED);
        GridData data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        this.dataSourceNameText.setLayoutData((Object)data);
        this.dataSourceNameText.setEditable(false);
        this.dataSourceNameText.setBackground(panel.getBackground());
        this.dataSourceNameText.setText(UNDEFINED);
        super.createDialogArea(panel);
        this.statusMessageLabel = new MessageLabel(panel);
        GridData statusData = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        this.statusMessageLabel.setLayoutData((Object)statusData);
        this.statusMessageLabel.setEnabled(false);
        this.statusMessageLabel.setText(UNDEFINED);
        this.getTreeViewer().expandToLevel(3);
        return panel;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = super.createTreeViewer(parent);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.getTree().setEnabled(true);
        viewer.setSorter(new ViewerSorter());
        viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ITeiidServer) {
                    return element.equals(DqpPlugin.getInstance().getServerManager().getDefaultServer());
                }
                return true;
            }
        }, new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ITeiidDataSource) {
                    String name = ((ITeiidDataSource)element).getName();
                    return !name.startsWith("PREVIEW_");
                }
                return true;
            }
        }});
        return viewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TreeSelection selection = (TreeSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.selectedDataSource = null;
            this.dataSourceNameText.setText(UNDEFINED);
            this.updateOnSelection(null);
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof ITeiidDataSource)) {
            this.selectedDataSource = null;
            this.dataSourceNameText.setText(UNDEFINED);
        } else {
            this.selectedDataSource = (ITeiidDataSource)selection.getFirstElement();
            this.dataSourceNameText.setText(this.selectedDataSource.getName());
        }
        this.updateOnSelection(firstElement);
    }

    private void updateOnSelection(Object selectedObject) {
        Status status = new Status(1, "org.teiid.designer.dqp.ui", DqpUiConstants.UTIL.getString("SelectJndiDataSourceDialog.okSelectionMessage", new Object[0]));
        if (selectedObject != null) {
            if (!(selectedObject instanceof ITeiidDataSource)) {
                status = new Status(4, "org.teiid.designer.dqp.ui", DqpUiConstants.UTIL.getString("SelectJndiDataSourceDialog.invalidSelectionMessage", new Object[0]));
                this.getOkButton().setEnabled(false);
            } else {
                this.getOkButton().setEnabled(true);
            }
        } else {
            status = new Status(4, "org.teiid.designer.dqp.ui", DqpUiConstants.UTIL.getString("SelectJndiDataSourceDialog.invalidSelectionMessage", new Object[0]));
            this.getOkButton().setEnabled(false);
        }
        this.statusMessageLabel.setErrorStatus((IStatus)status);
    }

    public ITeiidDataSource getSelectedTranslator() {
        return this.selectedDataSource;
    }
}

