/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import java.util.Properties;
import org.teiid.designer.runtime.spi.ITeiidServer;

public class VdbDataSourceInfo {
    private static final String PASS_THROUGH_KEY = "PassthroughAuthentication";
    private static final String PASSWORD_KEY = "password";
    private static final String USERNAME_KEY = "user-name";
    private static final String CONNECTION_URL_KEY = "connection-url";
    private static final String DRIVER_CLASS_KEY = "driver-class";
    private static final String TEIID_DRIVER_CLASS_NAME = "org.teiid.jdbc.TeiidDriver";
    private static final String TEIID_JDBC_URL_PREFIX = "jdbc:teiid:";
    private static final char SEMI_COLON = ';';
    private static final String PROTOCOL = "@mm";
    private static final String DELIMITER = "//";
    private static final String SECURE_PROTOCOL = "@mms";
    private static final char COLON = ':';
    private static final char EQUALS = '=';
    private static final String TRUE_VALUE = "\"true\"";
    private String vdbName;
    private String displayName;
    private String jndiName;
    private String username;
    private String password;
    private ITeiidServer teiidServer;
    private boolean passThroughAuthentication;

    public VdbDataSourceInfo() {
    }

    public VdbDataSourceInfo(String vdbName, String displayName, String jndiName, ITeiidServer teiidServer) {
        this.vdbName = vdbName;
        this.displayName = displayName;
        this.jndiName = jndiName;
        this.teiidServer = teiidServer;
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPassThroughAuthentication() {
        return this.passThroughAuthentication;
    }

    public void setPassThroughAuthentication(boolean passThroughAuthentication) {
        this.passThroughAuthentication = passThroughAuthentication;
    }

    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(TEIID_JDBC_URL_PREFIX).append(this.vdbName);
        String host = this.teiidServer.getTeiidJdbcInfo().getHost();
        String port = this.teiidServer.getTeiidJdbcInfo().getPort();
        String protocol = this.teiidServer.getTeiidJdbcInfo().isSecure() ? SECURE_PROTOCOL : PROTOCOL;
        sb.append(protocol).append(':').append(DELIMITER).append(host).append(':').append(port);
        if (this.isPassThroughAuthentication()) {
            sb.append(';').append(PASS_THROUGH_KEY).append('=').append(TRUE_VALUE).append(';');
        }
        return sb.toString();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.username != null) {
            props.put(USERNAME_KEY, this.username);
        }
        if (this.password != null) {
            props.put(PASSWORD_KEY, this.password);
        }
        props.put(DRIVER_CLASS_KEY, TEIID_DRIVER_CLASS_NAME);
        props.put(CONNECTION_URL_KEY, this.getUrl());
        return props;
    }
}

