/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection.properties;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.connection.properties.TranslatorOverride;
import org.teiid.designer.ui.common.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.viewsupport.TranslatorOverridePropertyEditingSupport;
import org.teiid.designer.ui.viewsupport.TranslatorPropertyLabelProvider;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class EditTOPropertiesPanel {
    static final String PREFIX = I18nUtil.getPropertyPrefix(EditTOPropertiesPanel.class);
    private final TableViewer propertiesViewer;

    public EditTOPropertiesPanel(Composite parent, final TranslatorOverride override) {
        Group mainPanel = WidgetFactory.createGroup((Composite)parent, (String)DqpUiPlugin.UTIL.getString("EditTOPropertiesPanel.0_translatorProperties", (Object)override.getType().toUpperCase()));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainPanel);
        Composite pnlOverrides = new Composite((Composite)mainPanel, 4);
        pnlOverrides.setLayout((Layout)new GridLayout(2, false));
        pnlOverrides.setLayoutData((Object)new GridData(4, 4, true, true));
        this.propertiesViewer = new TableViewer(pnlOverrides, 68352);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertiesViewer);
        this.propertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return override.getProperties();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertiesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TranslatorOverrideProperty prop1 = (TranslatorOverrideProperty)e1;
                TranslatorOverrideProperty prop2 = (TranslatorOverrideProperty)e2;
                return super.compare(viewer, (Object)prop1.getDefinition().getDisplayName(), (Object)prop2.getDefinition().getDisplayName());
            }
        });
        int visibleTableRows = 7;
        Table table = this.propertiesViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)table.getLayoutData()).horizontalSpan = 2;
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * visibleTableRows;
        TableViewerColumn column = new TableViewerColumn(this.propertiesViewer, 16384);
        column.getColumn().setText(DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "propertyColumn.text", new Object[0]));
        column.setLabelProvider((CellLabelProvider)new TranslatorPropertyLabelProvider(true));
        column.getColumn().setWidth(400);
        column = new TableViewerColumn(this.propertiesViewer, 16384);
        column.getColumn().setText(DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "valueColumn.text", new Object[0]));
        column.setLabelProvider((CellLabelProvider)new TranslatorPropertyLabelProvider(false));
        column.setEditingSupport((EditingSupport)new TOPropertyEditingSupport((ColumnViewer)this.propertiesViewer));
        column.getColumn().setWidth(150);
        if (override.getProperties().length == 0) {
            ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 4;
        }
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)pnlOverrides, (int)0, (int)2, (int)1, (int)1);
        Label noteLabel = WidgetFactory.createLabel((Composite)toolbarPanel, (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "overridePropertiesNoteLabel", new Object[0]));
        noteLabel.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)noteLabel);
        noteLabel.setToolTipText(DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "overridePropertiesNoteTooltip", new Object[0]));
        this.propertiesViewer.setInput((Object)this);
    }

    private TranslatorOverrideProperty getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertiesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (TranslatorOverrideProperty)selection.getFirstElement();
    }

    void handleRestorePropertyDefaultValue() {
        assert (!this.propertiesViewer.getSelection().isEmpty());
        TranslatorOverrideProperty prop = this.getSelectedProperty();
        prop.setValue(null);
        this.propertiesViewer.refresh((Object)prop);
    }

    public void refresh() {
        this.propertiesViewer.setInput((Object)this);
        this.propertiesViewer.refresh();
    }

    public boolean canFinish() {
        return true;
    }

    class PropertyLabelProvider
    extends ColumnLabelProvider {
        private final boolean nameColumn;

        public PropertyLabelProvider(boolean nameColumn) {
            this.nameColumn = nameColumn;
        }

        public Image getImage(Object element) {
            TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
            String overridenValue = property.getOverriddenValue();
            Image image = null;
            if (!this.nameColumn) {
                if (property.getDefinition().isValidValue(overridenValue) == null) {
                    if (!(!property.hasOverridenValue() || property.isCustom() && property.getDefinition().getDefaultValue().equals(overridenValue))) {
                        image = VdbUiPlugin.singleton.getImage("icons/full/ctool16/restore-default-value.png");
                    }
                } else {
                    image = UiPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
            }
            return image;
        }

        public String getText(Object element) {
            TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
            if (this.nameColumn) {
                return property.getDefinition().getDisplayName();
            }
            boolean masked = property.getDefinition().isMasked();
            if (property.hasOverridenValue()) {
                return masked ? "*****" : property.getOverriddenValue();
            }
            return masked ? "*****" : property.getDefinition().getDefaultValue();
        }

        public String getToolTipText(Object element) {
            TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
            if (this.nameColumn) {
                return property.getDefinition().getDescription();
            }
            if (!(!property.hasOverridenValue() || property.isCustom() && property.getDefinition().getDefaultValue().equals(property.getOverriddenValue()))) {
                return property.getDefinition().isValidValue(property.getOverriddenValue());
            }
            return "<USING DEFAULT PROPERTY VALUE>";
        }
    }

    class TOPropertyEditingSupport
    extends TranslatorOverridePropertyEditingSupport {
        public TOPropertyEditingSupport(ColumnViewer viewer) {
            super(viewer, null);
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }
}

