/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.dialogs;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnSetAspect;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.dialogs.PreviewParameterPanel;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;

public class AccessPatternColumnsDialog
extends TitleAreaDialog
implements DqpUiConstants,
ISelectionChangedListener,
IChangeListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AccessPatternColumnsDialog.class);
    private final EObject[] accessPatterns;
    private List<String> columnValues;
    private ILabelProvider labelProvider = new ModelExplorerLabelProvider();
    private Map<EObject, PreviewParameterPanel> patternPanelMap = new HashMap<EObject, PreviewParameterPanel>();
    private Composite pnlParams;
    private EObject selectedPattern;
    private StackLayout stackLayout;
    private TableViewer viewer;

    public AccessPatternColumnsDialog(Shell parentShell, Collection<EObject> accessPatterns) {
        super(parentShell);
        this.accessPatterns = accessPatterns.toArray(new EObject[accessPatterns.size()]);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    EObject[] accessAccessPatterns() {
        return this.accessPatterns;
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            this.columnValues = this.patternPanelMap.get(this.getSelectedAccessPattern()).getColumnValues();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UTIL.getString(String.valueOf(PREFIX) + "title", new Object[0]));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.accessPatterns[0]), false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        SashForm splitter = WidgetFactory.createSplitter((Composite)((Composite)super.createDialogArea(parent)), (int)256);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        splitter.setLayoutData((Object)gid);
        this.createList((Composite)splitter);
        this.pnlParams = WidgetFactory.createGroup((Composite)splitter, (String)UTIL.getString(String.valueOf(PREFIX) + "requiredColumns", new Object[0]));
        this.stackLayout = new StackLayout();
        this.pnlParams.setLayout((Layout)this.stackLayout);
        this.pnlParams.setLayoutData((Object)new GridData(1808));
        splitter.setWeights(new int[]{4, 6});
        splitter.layout();
        this.selectedPattern = this.accessPatterns[0];
        this.getPanel(this.selectedPattern);
        this.setTitle(UTIL.getString(String.valueOf(PREFIX) + "header", new Object[0]));
        return splitter;
    }

    private void createList(Composite parent) {
        Group listPanel = WidgetFactory.createGroup((Composite)parent, (String)UTIL.getString(String.valueOf(PREFIX) + "patternsGroupTitle", new Object[0]), (int)1808);
        this.viewer = new TableViewer((Composite)listPanel, 68352);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new AccessPatternContentProvider());
        this.viewer.setInput((Object)this);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
    }

    public List getColumns() {
        assert (this.getReturnCode() == 0);
        return ((SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)this.getSelectedAccessPattern())).getColumns(this.getSelectedAccessPattern());
    }

    public List<String> getColumnValues() {
        assert (this.getReturnCode() == 0);
        return this.columnValues;
    }

    private PreviewParameterPanel getPanel(EObject accessPattern) {
        PreviewParameterPanel panel = this.patternPanelMap.get(accessPattern);
        if (panel == null) {
            panel = new PreviewParameterPanel(this.pnlParams, accessPattern);
            panel.addChangeListener(this);
            this.patternPanelMap.put(accessPattern, panel);
        }
        return panel;
    }

    private EObject getSelectedAccessPattern() {
        return this.selectedPattern;
    }

    private PreviewParameterPanel getSelectedPanel() {
        return this.getPanel(this.getSelectedAccessPattern());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            this.selectedPattern = null;
        } else {
            this.selectedPattern = (EObject)selection.getFirstElement();
            this.setTopControl((Control)this.getSelectedPanel());
        }
        this.updateState();
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void setTopControl(Control newTopControl) {
        this.stackLayout.topControl = newTopControl;
        this.pnlParams.layout(true, true);
    }

    private void updateState() {
        IStatus status = this.getSelectedPanel().getStatus();
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(UTIL.getString(String.valueOf(PREFIX) + "okMsg", new Object[0]));
        }
    }

    class AccessPatternContentProvider
    implements IStructuredContentProvider {
        AccessPatternContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return AccessPatternColumnsDialog.this.accessAccessPatterns();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

