/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.dialogs.PreviewParameterPanel;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ParameterInputDialog
extends TitleAreaDialog
implements DqpUiConstants,
IChangeListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ParameterInputDialog.class);
    private List<EObject> parameters;
    private List<String> parameterValues;
    private PreviewParameterPanel pnlParams;

    public ParameterInputDialog(Shell parentShell, List<EObject> parameters) {
        super(parentShell);
        this.parameters = parameters;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UTIL.getString(String.valueOf(PREFIX) + "title", new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.setTitle(UTIL.getString(String.valueOf(PREFIX) + "header", new Object[0]));
        Group paramGroup = WidgetFactory.createGroup((Composite)composite, (String)UTIL.getString(String.valueOf(PREFIX) + "inputParameters", new Object[0]), (int)0, (int)1, (int)3);
        paramGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pnlParams = new PreviewParameterPanel((Composite)paramGroup, this.parameters);
        this.pnlParams.addChangeListener(this);
        return composite;
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            this.parameterValues = this.pnlParams.getColumnValues();
        }
        return super.close();
    }

    public List<String> getParameterValues() {
        assert (this.getReturnCode() == 0);
        return this.parameterValues;
    }

    protected Control createButtonBar(Composite theParent) {
        Control theCntl = super.createButtonBar(theParent);
        this.getButton(0).setEnabled(false);
        this.stateChanged(null);
        return theCntl;
    }

    public void stateChanged(IChangeNotifier theSource) {
        IStatus status = this.pnlParams.getStatus();
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(UTIL.getString(String.valueOf(PREFIX) + "okMsg", new Object[0]));
        }
    }
}

