/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnSetAspect;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.dialogs.ParameterValueValidator;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PreviewParameterPanel
extends ScrolledComposite
implements DqpUiConstants,
IChangeNotifier {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(PreviewParameterPanel.class);
    private static final IStatus ERROR_STATUS = new Status(4, "org.teiid.designer.dqp.ui", 0, UTIL.getString(String.valueOf(PREFIX) + "errorStatus", new Object[0]), null);
    private static final IStatus GOOD_STATUS = new Status(0, "org.teiid.designer.dqp.ui", 0, UTIL.getString(String.valueOf(PREFIX) + "goodStatus", new Object[0]), null);
    private List<Label> images;
    private List<Label> names;
    private List<IChangeListener> listeners;
    private IStatus overallStatus = ERROR_STATUS;
    private Composite pnlMain;
    private IStatus[] statuses;
    private List<Text> textFields;

    private PreviewParameterPanel(Composite parent) {
        super(parent, 768);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        ScrollBar bar = this.getHorizontalBar();
        if (bar != null) {
            bar.setIncrement(12);
            bar.setPageIncrement(60);
        }
        if ((bar = this.getVerticalBar()) != null) {
            bar.setIncrement(12);
            bar.setPageIncrement(60);
        }
        this.pnlMain = WidgetFactory.createPanel((Composite)this, (int)0, (int)1808);
        ((GridLayout)this.pnlMain.getLayout()).numColumns = 4;
        this.setContent((Control)this.pnlMain);
    }

    public PreviewParameterPanel(Composite parent, List<EObject> parameters) {
        this(parent);
        this.createParameterControls(this.pnlMain, parameters);
        this.postInit();
    }

    public PreviewParameterPanel(Composite parent, EObject accessPattern) {
        this(parent);
        SqlColumnSetAspect aspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)accessPattern);
        this.createParameterControls(this.pnlMain, aspect.getColumns(accessPattern));
        this.postInit();
    }

    public void addChangeListener(IChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IChangeListener>(1);
        }
        this.listeners.add(listener);
    }

    private void createParameterControls(Composite parent, List<EObject> parameters) {
        AdapterFactoryLabelProvider labelProvider = ModelUtilities.getAdapterFactoryLabelProvider();
        int numCols = parameters.size();
        this.names = new ArrayList<Label>(numCols);
        this.images = new ArrayList<Label>(numCols);
        this.textFields = new ArrayList<Text>(numCols);
        this.statuses = new IStatus[numCols];
        for (EObject param : parameters) {
            Label name = new Label(parent, 0);
            name.setText(labelProvider.getText((Object)param));
            this.names.add(name);
            Label image = new Label(parent, 0);
            image.setImage(UiPlugin.getDefault().getImage("icons/full/cview16/blank.gif"));
            this.images.add(image);
            final Text textField = WidgetFactory.createTextField((Composite)parent);
            final ModifyListener modifyListener = this.createModifyListener(param);
            textField.addModifyListener(modifyListener);
            textField.setLayoutData((Object)new GridData(4, 4, true, false));
            if (this.textFields.isEmpty()) {
                textField.setFocus();
            }
            this.textFields.add(textField);
            Event e = new Event();
            e.widget = textField;
            modifyListener.modifyText(new ModifyEvent(e));
            if (ParameterValueValidator.canBeNull(param)) {
                final Button btn = WidgetFactory.createCheckBox((Composite)parent, (String)UTIL.getString(String.valueOf(PREFIX) + "chkNullValue", new Object[0]));
                btn.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "chkNullValue.tip", new Object[0]));
                btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        textField.setEnabled(!btn.getSelection());
                        if (textField.isEnabled()) {
                            textField.setFocus();
                        }
                        Event event = new Event();
                        event.widget = textField;
                        modifyListener.modifyText(new ModifyEvent(event));
                    }
                });
                continue;
            }
            WidgetFactory.createPanel((Composite)parent);
        }
    }

    private ModifyListener createModifyListener(final EObject column) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text textField = (Text)e.widget;
                IStatus status = ParameterValueValidator.isValidValue(column, PreviewParameterPanel.this.getValue(textField));
                PreviewParameterPanel.this.setStatus(status, textField);
            }
        };
        return modifyListener;
    }

    public void dispose() {
        for (IChangeListener listener : this.listeners) {
            this.removeChangeListener(listener);
        }
        super.dispose();
    }

    private void fireStateChanged() {
        if (this.listeners != null) {
            for (IChangeListener listener : this.listeners) {
                listener.stateChanged((IChangeNotifier)this);
            }
        }
    }

    public List<String> getColumnValues() {
        ArrayList<String> values = new ArrayList<String>(this.textFields.size());
        for (Text textField : this.textFields) {
            values.add(this.getValue(textField));
        }
        return values;
    }

    String getValue(Text textField) {
        return textField.getEnabled() ? textField.getText() : null;
    }

    public IStatus getStatus() {
        return this.overallStatus;
    }

    private void postInit() {
        Point pt = this.computeSize(-1, -1);
        this.setMinWidth(pt.x);
        this.setMinHeight(pt.y);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
    }

    public void removeChangeListener(IChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    void setStatus(IStatus fieldStatus, Text textField) {
        int index = this.textFields.indexOf(textField);
        this.statuses[index] = fieldStatus;
        Label lblName = this.names.get(index);
        Label lblIcon = this.images.get(index);
        Image image = null;
        String toolTip = null;
        if (fieldStatus == null || fieldStatus.getSeverity() != 4) {
            image = UiPlugin.getDefault().getImage("icons/full/cview16/blank.gif");
            toolTip = "";
        } else {
            image = UiPlugin.getDefault().getImage("icons/full/obj16/error_obj.gif");
            toolTip = fieldStatus.getMessage();
        }
        lblName.setToolTipText(toolTip);
        lblIcon.setImage(image);
        lblIcon.setToolTipText(toolTip);
        textField.setToolTipText(toolTip);
        this.overallStatus = GOOD_STATUS;
        IStatus[] iStatusArray = this.statuses;
        int n = this.statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status != null && status.getSeverity() == 4) {
                this.overallStatus = ERROR_STATUS;
                break;
            }
            ++n2;
        }
        this.fireStateChanged();
    }
}

