/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.ui.preferences.IGeneralPreferencePageContributor;

public class TeiidImporterTimeoutPreferenceContributor
implements IGeneralPreferencePageContributor,
DqpUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TeiidImporterTimeoutPreferenceContributor.class);
    private Spinner timeoutSecTextField;

    public void createPreferenceEditor(Composite theParent) {
        Composite pnl = new Composite(theParent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData());
        this.timeoutSecTextField = new Spinner(pnl, 2048);
        this.timeoutSecTextField.setToolTipText(this.getToolTip());
        this.timeoutSecTextField.setMaximum(999);
        this.timeoutSecTextField.setMinimum(0);
        Label label = new Label(pnl, 0);
        label.setText(this.getName());
        label.setToolTipText(this.getToolTip());
        this.refresh();
    }

    public String getName() {
        return UTIL.getStringOrKey(String.valueOf(PREFIX) + "name");
    }

    private IEclipsePreferences getPreferences() {
        return DqpPlugin.getInstance().getPreferences();
    }

    public String getToolTip() {
        return UTIL.getStringOrKey(String.valueOf(PREFIX) + "toolTip");
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performDefaults() {
        this.timeoutSecTextField.setSelection(120);
        try {
            this.getPreferences().flush();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public boolean performOk() {
        IEclipsePreferences prefs = this.getPreferences();
        int timeout = this.timeoutSecTextField.getSelection();
        prefs.putInt("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", timeout);
        try {
            prefs.flush();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public void refresh() {
        IEclipsePreferences prefs = this.getPreferences();
        int timeoutSec = prefs.getInt("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", 120);
        this.timeoutSecTextField.setSelection(timeoutSec);
    }

    public void setPreferencePage(PreferencePage preferencePage) {
    }

    public void setWorkbench(IWorkbench theWorkbench) {
    }
}

