/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.preview;

import java.util.Properties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;

public class PreviewDataInputDialog
extends TitleAreaDialog
implements DqpUiConstants {
    private EObject previewableEObject;
    private ILabelProvider labelProvider = new ModelExplorerLabelProvider();
    private SqlTextViewer sqlTextViewer;
    private Document sqlDocument;
    private TabItem sqlTab;
    private TabItem vdbXmlTab;
    private StyledText xmlContentsBox;
    Properties designerProperties;
    private Font monospaceFont;
    String sqlText;
    String dynVdbXml;

    public PreviewDataInputDialog(Shell parentShell, String initialSQL, String dynVdbXml) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.sqlText = initialSQL;
        this.dynVdbXml = dynVdbXml;
    }

    public PreviewDataInputDialog(Shell parentShell, Properties properties, String initialSQL, String dynVdbXml) {
        this(parentShell, initialSQL, dynVdbXml);
        this.designerProperties = properties;
    }

    public boolean close() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Custom Preview Data");
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(true);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        this.monospaceFont(parent);
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(10, 10).applyTo(pnlOuter);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pnlOuter);
        this.setTitle(Messages.PreviewDataInputDialog_title);
        this.setMessage(Messages.PreviewDataInputDialog_initialMessage);
        TabFolder folder = this.createTabFolder(pnlOuter);
        this.createSQLTab(folder);
        this.createVdbXmlTabTab(folder);
        return pnlOuter;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        return control;
    }

    public EObject getPreviewableEObject() {
        return this.previewableEObject;
    }

    protected TabFolder createTabFolder(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 2176);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tabFolder);
        return tabFolder;
    }

    private void createSQLTab(TabFolder folderParent) {
        Composite thePanel = this.createSQLPanel((Composite)folderParent);
        this.sqlTab = new TabItem(folderParent, 0);
        this.sqlTab.setControl((Control)thePanel);
        this.sqlTab.setText(Messages.PreviewDataInputDialog_previewSqlLabel);
    }

    private Composite createSQLPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        this.createSqlGroup(thePanel);
        return thePanel;
    }

    private void createSqlGroup(Composite parent) {
        Group textTableOptionsGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.PreviewDataInputDialog_sqlQueryLabel, (int)0, (int)2, (int)1);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)textTableOptionsGroup);
        ColorManager colorManager = new ColorManager();
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)textTableOptionsGroup, (IVerticalRuler)new VerticalRuler(0), styles, colorManager);
        this.sqlDocument = new Document();
        this.sqlTextViewer.setInput((Object)this.sqlDocument);
        this.sqlTextViewer.getTextWidget().setFont(this.monospaceFont);
        this.sqlTextViewer.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreviewDataInputDialog.this.sqlText = PreviewDataInputDialog.this.sqlTextViewer.getTextWidget().getText();
            }
        });
        this.sqlTextViewer.setEditable(true);
        this.sqlDocument.set(this.sqlText);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.sqlTextViewer.getControl());
    }

    public String getSQL() {
        return this.sqlText;
    }

    private void createVdbXmlTabTab(TabFolder folderParent) {
        Composite thePanel = this.createVdbXmlPanel((Composite)folderParent);
        this.vdbXmlTab = new TabItem(folderParent, 0);
        this.vdbXmlTab.setControl((Control)thePanel);
        this.vdbXmlTab.setText(Messages.PreviewDataInputDialog_previewXMLLabel);
    }

    private Composite createVdbXmlPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        this.createXMLDisplayGroup(thePanel);
        return thePanel;
    }

    private void createXMLDisplayGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.PreviewDataInputDialog_previewDynamicVdbXmlTabLabel, (int)1808, (int)1);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(10, 10).applyTo((Composite)theGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)theGroup);
        this.xmlContentsBox = new StyledText((Composite)theGroup, 2826);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 300).applyTo((Control)this.xmlContentsBox);
        this.xmlContentsBox.setEditable(false);
        this.xmlContentsBox.setFont(this.monospaceFont);
        this.xmlContentsBox.setText(this.dynVdbXml);
    }

    private Font monospaceFont(Composite composite) {
        if (this.monospaceFont == null) {
            this.monospaceFont = new Font((Device)composite.getDisplay(), "Monospace", 12, 0);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (PreviewDataInputDialog.this.monospaceFont == null) {
                        return;
                    }
                    PreviewDataInputDialog.this.monospaceFont.dispose();
                }
            });
        }
        return this.monospaceFont;
    }
}

