/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.preview;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.datatools.connectivity.ConnectivityUtil;
import org.teiid.datatools.connectivity.ui.TeiidAdHocScriptRunnable;
import org.teiid.datatools.views.ExecutionPlanView;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidJdbcInfo;
import org.teiid.designer.runtime.preview.PreviewManager;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.dialogs.AccessPatternColumnsDialog;
import org.teiid.designer.runtime.ui.dialogs.ParameterInputDialog;
import org.teiid.designer.runtime.ui.preview.PreviewDataInputDialog;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.webservice.util.WebServiceUtil;

public class PreviewDataWorker {
    private static final String THIS_CLASS = I18nUtil.getPropertyPrefix(PreviewDataWorker.class);
    private PreviewManager manager;

    static String getString(String key) {
        return DqpUiConstants.UTIL.getString(String.valueOf(THIS_CLASS) + key, new Object[0]);
    }

    static String getString(String key, Object param) {
        return DqpUiConstants.UTIL.getString(String.valueOf(THIS_CLASS) + key, param);
    }

    static String getString(String key, Object param, Object param2) {
        return DqpUiConstants.UTIL.getString(String.valueOf(THIS_CLASS) + key, new Object[]{param, param2});
    }

    public boolean isPreviewPossible() {
        boolean doContinue;
        if (!ModelEditorManager.getDirtyResources().isEmpty() && !(doContinue = MessageDialog.openQuestion((Shell)this.getShell(), (String)PreviewDataWorker.getString("unsavedModelsWarning.title"), (String)PreviewDataWorker.getString("unsavedModelsWarning.message")))) {
            return false;
        }
        return RuntimeAssistant.ensurePreviewEnabled(this.getShell());
    }

    public boolean isPreviewableEObject(EObject eObject) {
        return ModelObjectUtilities.isExecutable((EObject)eObject);
    }

    public void run(EObject targetObject, boolean planOnly) {
        ConnectionInfoHelper helper = new ConnectionInfoHelper();
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)targetObject);
        if (mr != null && ModelIdentifier.isPhysicalModelType((ModelResource)mr)) {
            if (!helper.hasConnectionInfo(mr)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)PreviewDataWorker.getString("noPreviewAvailableTitle"), (String)PreviewDataWorker.getString("noProfileAvailableMissingConnectionInfoMessage", mr.getItemName()));
                return;
            }
            String translatorName = helper.getTranslatorName(mr);
            if (translatorName != null) {
                boolean result;
                ITeiidTranslator tt = null;
                try {
                    tt = this.getServerManager().getDefaultServer().getTranslator(translatorName);
                }
                catch (Exception e) {
                    DqpUiConstants.UTIL.log((Throwable)e);
                }
                if (tt == null && !(result = MessageDialog.openQuestion((Shell)this.getShell(), (String)PreviewDataWorker.getString("noMatchingTranslatorTitle"), (String)PreviewDataWorker.getString("noMatchingTeiidTranslatorMessage", translatorName, mr.getItemName())))) {
                    return;
                }
            }
        }
        if (!this.validateResultDisplayProperties()) {
            return;
        }
        this.manager = new PreviewManager(targetObject);
        try {
            this.internalRun(targetObject, planOnly);
        }
        catch (ModelWorkspaceException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalRun(EObject eObject, boolean planOnly) throws ModelWorkspaceException {
        void var4_14;
        TitleAreaDialog dialog;
        TitleAreaDialog dialog2;
        String sql = null;
        Object var4_4 = null;
        Shell shell = this.getShell();
        boolean isXML = false;
        List accessPatternsColumns = null;
        if (SqlAspectHelper.isTable((EObject)eObject)) {
            SqlTableAspect tableAspect = (SqlTableAspect)SqlAspectHelper.getSqlAspect((EObject)eObject);
            Collection accessPatterns = tableAspect.getAccessPatterns(eObject);
            if (accessPatterns != null && !accessPatterns.isEmpty()) {
                ArrayList<EObject> patterns = new ArrayList<EObject>(accessPatterns.size());
                for (Object pattern : accessPatterns) {
                    patterns.add((EObject)pattern);
                }
                dialog2 = new AccessPatternColumnsDialog(shell, patterns);
                if (dialog2.open() != 0) return;
                accessPatternsColumns = dialog2.getColumns();
                List<String> list = dialog2.getColumnValues();
            } else {
                List list = Collections.emptyList();
            }
        }
        if (eObject instanceof Operation) {
            List inputElements = WebServiceUtil.getInputElements((Operation)((Operation)eObject), (boolean)false);
            if (!inputElements.isEmpty()) {
                dialog = this.getInputDialog(inputElements);
                dialog.open();
                if (dialog.getReturnCode() != 0) return;
                List<String> list = dialog.getParameterValues();
                sql = WebServiceUtil.getSql((Operation)((Operation)eObject), list);
                List list2 = Collections.emptyList();
            } else {
                List list = Collections.emptyList();
                sql = WebServiceUtil.getSql((Operation)((Operation)eObject), list);
            }
            isXML = true;
        } else if (SqlAspectHelper.isProcedure((EObject)eObject)) {
            SqlProcedureAspect procAspect = (SqlProcedureAspect)SqlAspectHelper.getSqlAspect((EObject)eObject);
            List params = procAspect.getParameters(eObject);
            ArrayList<EObject> inParams = new ArrayList<EObject>();
            for (EObject param : params) {
                DirectionKind direction;
                int directionKind;
                if (!(param instanceof ProcedureParameter) || (directionKind = (direction = ((ProcedureParameter)param).getDirection()).getValue()) != 0 && directionKind != 2) continue;
                inParams.add(param);
            }
            if (!inParams.isEmpty()) {
                dialog2 = this.getInputDialog(inParams);
                dialog2.open();
                if (dialog2.getReturnCode() != 0) return;
                List<String> list = dialog2.getParameterValues();
            } else {
                List list = Collections.emptyList();
            }
        }
        assert (var4_14 != null);
        Object[] paramValuesAsArray = var4_14.toArray();
        if (sql == null) {
            sql = ModelObjectUtilities.getSQL((EObject)eObject, (Object[])paramValuesAsArray, accessPatternsColumns);
            sql = this.insertParameterValuesSQL(sql, (List<String>)var4_14);
        }
        if (sql == null) {
            DqpUiConstants.UTIL.log((IStatus)new Status(2, "org.teiid.designer.dqp.ui", 0, "failed to produce valid SQL to execute", null));
            return;
        }
        dialog = new PreviewDataInputDialog(this.getShell(), sql, this.manager.getDynamicVdbString());
        if (dialog.open() != 0) {
            return;
        }
        IStatus status = this.manager.deployDynamicVdb();
        if (status.isOK()) {
            sql = dialog.getSQL();
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"VDB Deployment Error", (String)status.getMessage());
        }
        ITeiidServer defaultServer = this.getServerManager().getDefaultServer();
        try {
            String driverPath = defaultServer.getAdminDriverPath();
            String vdbName = this.manager.getPreviewVdbName();
            TeiidJdbcInfo jdbcInfo = new TeiidJdbcInfo(vdbName, defaultServer.getTeiidJdbcInfo());
            IConnectionProfile profile = ConnectivityUtil.createTransientTeiidProfile((ITeiidServerVersion)defaultServer.getServerVersion(), (String)driverPath, (String)jdbcInfo.getUrl(), (String)jdbcInfo.getUsername(), (String)jdbcInfo.getPassword(), (String)vdbName);
            IConnection connection = this.getSqlConnection(profile);
            Connection sqlConnection = (Connection)connection.getRawConnection();
            if (sqlConnection == null || sqlConnection.isClosed()) {
                Throwable e = connection.getConnectException();
                if (e != null) {
                    DqpUiConstants.UTIL.log(e);
                } else {
                    DqpUiConstants.UTIL.log((Object)"Unspecified connection error");
                }
                MessageDialog.openError((Shell)this.getShell(), (String)PreviewDataWorker.getString("error_getting_connection.title"), (String)PreviewDataWorker.getString("error_getting_connection.message"));
                return;
            }
            DatabaseIdentifier ID = new DatabaseIdentifier(profile.getName(), vdbName);
            ILaunchConfigurationWorkingCopy config = this.creatLaunchConfig(sql, ID);
            if (planOnly) {
                this.executePlan(sqlConnection, sql, eObject, profile);
                return;
            }
            String labelStr = null;
            labelStr = isXML ? String.valueOf(PreviewDataWorker.getString("previewWithPlanFor.label")) + " " + ModelerCore.getModelEditor().getName(eObject) : String.valueOf(PreviewDataWorker.getString("previewWithPlanFor.label")) + " " + ModelerCore.getModelEditor().getName(eObject);
            String finalSQL = dialog.getSQL();
            this.executeSQLResultRunnable(sqlConnection, labelStr, finalSQL, ID, config, profile, this.manager);
            return;
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log(4, e.getMessage());
        }
    }

    private void executeSQLResultRunnable(final Connection sqlConnection, final String labelStr, final String sql, final DatabaseIdentifier ID, final ILaunchConfigurationWorkingCopy config, final IConnectionProfile profile, final PreviewManager previewManager) {
        Job job = new Job(String.valueOf(labelStr) + " ..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CleanUpRunnable runnable = new CleanUpRunnable(sqlConnection, labelStr, sql, true, null, monitor, ID, (ILaunchConfiguration)config, previewManager);
                    runnable.run();
                }
                catch (Throwable throwable) {
                    try {
                        sqlConnection.close();
                    }
                    catch (Exception exception) {}
                    ConnectivityUtil.deleteTransientTeiidProfile((IConnectionProfile)profile);
                    throw throwable;
                }
                try {
                    sqlConnection.close();
                }
                catch (Exception exception) {}
                ConnectivityUtil.deleteTransientTeiidProfile((IConnectionProfile)profile);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
    }

    private void executePlan(final Connection sqlConnection, final String sql, final EObject eObject, final IConnectionProfile profile) {
        Job job = new Job(DqpUiConstants.UTIL.getString(String.valueOf(THIS_CLASS) + "RetrieveExecutionPlanJob", new Object[0])){

            protected IStatus run(IProgressMonitor monitor) {
                block11: {
                    try {
                        try {
                            final String planStr = PreviewDataWorker.this.getExecutionPlan(sqlConnection, sql);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                    IViewPart viewPart = null;
                                    try {
                                        if (window != null && (viewPart = window.getActivePage().showView("views.executionPlanView")) instanceof ExecutionPlanView) {
                                            String labelStr = String.valueOf(PreviewDataWorker.getString("planOnlyFetchFor.label")) + " " + ModelerCore.getModelEditor().getName(eObject);
                                            ((ExecutionPlanView)viewPart).updateContents(labelStr, sql, planStr);
                                        }
                                    }
                                    catch (PartInitException e) {
                                        DqpUiConstants.UTIL.log((Throwable)e);
                                        WidgetUtil.showError((String)e.getLocalizedMessage());
                                    }
                                }
                            });
                        }
                        catch (SQLException ex) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DqpUiConstants.UTIL.log((Throwable)ex);
                                    MessageDialog.openError((Shell)PreviewDataWorker.this.getShell(), (String)PreviewDataWorker.getString("errorGeneratingExecutionPlan.title"), (String)PreviewDataWorker.getString("errorGeneratingExecutionPlan.message"));
                                }
                            });
                            try {
                                sqlConnection.close();
                            }
                            catch (Exception exception) {}
                            ConnectivityUtil.deleteTransientTeiidProfile((IConnectionProfile)profile);
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            sqlConnection.close();
                        }
                        catch (Exception exception) {}
                        ConnectivityUtil.deleteTransientTeiidProfile((IConnectionProfile)profile);
                        throw throwable;
                    }
                    try {
                        sqlConnection.close();
                    }
                    catch (Exception exception) {}
                    ConnectivityUtil.deleteTransientTeiidProfile((IConnectionProfile)profile);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
    }

    private String getExecutionPlan(Connection sqlConnection, String sql) throws SQLException {
        String executionPlan = null;
        Statement stmt = sqlConnection.createStatement();
        stmt.execute("SET SHOWPLAN DEBUG");
        stmt.executeQuery(sql);
        ResultSet planRs = stmt.executeQuery("SHOW PLAN");
        planRs.next();
        executionPlan = planRs.getString("PLAN_XML");
        try {
            stmt.close();
        }
        catch (SQLException e) {
            DqpPlugin.Util.log((Throwable)e);
        }
        try {
            planRs.close();
        }
        catch (SQLException e) {
            DqpPlugin.Util.log((Throwable)e);
        }
        return executionPlan;
    }

    private ParameterInputDialog getInputDialog(List<EObject> params) {
        ParameterInputDialog dialog = new ParameterInputDialog(this.getShell(), params);
        return dialog;
    }

    private String insertParameterValuesSQL(String sql, List<String> paramValues) {
        if (paramValues != null && !paramValues.isEmpty()) {
            for (String value : paramValues) {
                sql = value == null ? sql.replaceFirst("\\?", "null") : (value.trim().startsWith("{") && value.trim().endsWith("}") ? sql.replaceFirst("\\?", value) : sql.replaceFirst("\\?", "'" + value + "'"));
            }
        }
        return sql;
    }

    private boolean validateResultDisplayProperties() {
        IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        if (!store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.unknownProfile")) {
            boolean isOK = MessageDialog.openQuestion((Shell)this.getShell(), (String)PreviewDataWorker.getString("propertyPromptTitle"), (String)PreviewDataWorker.getString("propertyPrompt"));
            if (isOK) {
                store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.unknownProfile", "true");
                return true;
            }
            return false;
        }
        return true;
    }

    private ITeiidServerManager getServerManager() {
        return DqpPlugin.getInstance().getServerManager();
    }

    protected Shell getShell() {
        return UiUtil.getWorkbenchShellOnlyIfUiThread();
    }

    private ILaunchConfigurationWorkingCopy creatLaunchConfig(String sql, DatabaseIdentifier ID) throws CoreException {
        ILaunchConfigurationWorkingCopy config = LaunchHelper.createExternalClientConfiguration((DatabaseIdentifier)ID, (String)"pvdb");
        config.setAttribute("org.eclipse.datatools.sqltools.debug.launching.triggersql", sql);
        config.setAttribute("org.eclipse.datatools.sqltools.debug.launching.type", 3);
        return config;
    }

    private IConnection getSqlConnection(IConnectionProfile profile) {
        IConnectionProfileProvider provider = profile.getProvider();
        IConnectionFactoryProvider factory = provider.getConnectionFactory("java.sql.Connection");
        String factoryId = factory.getId();
        return profile.createConnection(factoryId);
    }

    class CleanUpRunnable
    extends TeiidAdHocScriptRunnable {
        final PreviewManager previewManager;

        public CleanUpRunnable(Connection con, String description, String sql, boolean closeCon, IConnectionTracker tracker, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier, ILaunchConfiguration configuration, PreviewManager previewManager) {
            super(con, description, sql, closeCon, tracker, parentMonitor, databaseIdentifier, configuration);
            this.previewManager = previewManager;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = super.run(monitor);
            this.previewManager.undeployDynamicVdb();
            return status;
        }
    }

    class PreviewUnavailableDialog
    extends MessageDialog {
        boolean openProgressView;

        public PreviewUnavailableDialog(Shell parent) {
            super(parent, PreviewDataWorker.getString("previewUnavailableDialog.title"), null, PreviewDataWorker.getString("previewUnavailableDialog.message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.openProgressView = false;
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createCustomArea(Composite parent) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout(2, false));
            panel.setLayoutData((Object)new GridData(4, 4, true, true));
            Button btnOpenProgressView = new Button(panel, 32);
            btnOpenProgressView.setText(PreviewDataWorker.getString("previewUnavailableDialog.btnShowProgressView.text"));
            btnOpenProgressView.setToolTipText(PreviewDataWorker.getString("previewUnavailableDialog.btnShowProgressView.toolTip"));
            btnOpenProgressView.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreviewUnavailableDialog.this.setOpenProgressView(((Button)e.widget).getSelection());
                }
            });
            return panel;
        }

        void setOpenProgressView(boolean openProgressView) {
            this.openProgressView = openProgressView;
        }

        public boolean shouldOpenProgressView() {
            return this.openProgressView;
        }
    }
}

