/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.server;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.handlers.HandlerUtil;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public final class RefreshServerAction
extends BaseSelectionListenerAction
implements IHandler {
    private ITeiidServer selectedServer;

    public RefreshServerAction() {
        super(DqpUiConstants.UTIL.getString("serverRefreshActionText", new Object[0]));
        this.setToolTipText(DqpUiConstants.UTIL.getString("serverRefreshActionToolTip", new Object[0]));
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/refresh.gif"));
        this.setId("org.teiid.designer.server.refresh");
    }

    public void run() {
        if (this.selectedServer == null && !RuntimeAssistant.hasAvailableServers()) {
            String title = DqpUiConstants.UTIL.getString("noServerAvailableTitle", new Object[0]);
            String message = DqpUiConstants.UTIL.getString("noServerAvailableMessage", new Object[0]);
            MessageDialog.openError((Shell)RefreshServerAction.getShell(), (String)title, (String)message);
            return;
        }
        if (this.selectedServer == null) {
            this.selectedServer = RuntimeAssistant.selectServer(RefreshServerAction.getShell(), false);
            if (RuntimeAssistant.selectServerWasCancelled()) {
                return;
            }
        }
        if (this.selectedServer == null) {
            String title = DqpUiConstants.UTIL.getString("noServerAvailableTitle", new Object[0]);
            String message = DqpUiConstants.UTIL.getString("serverRefreshNoServer", new Object[0]);
            MessageDialog.openInformation((Shell)RefreshServerAction.getShell(), (String)title, (String)message);
            return;
        }
        UiBusyIndicator.showWhile((Display)RefreshServerAction.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!RefreshServerAction.this.selectedServer.isParentConnected()) {
                    WidgetUtil.showError((String)DqpUiConstants.UTIL.getString("serverRefreshParentNotConnected", (Object)RefreshServerAction.this.selectedServer.getParent()));
                    return;
                }
                RefreshServerAction.this.selectedServer.reconnect();
                if (RefreshServerAction.this.selectedServer.getConnectionError() != null) {
                    WidgetUtil.showError((String)RefreshServerAction.this.selectedServer.getConnectionError());
                } else {
                    WidgetUtil.showNotification((String)DqpUiConstants.UTIL.getString("serverRefreshServerSuccessful", new Object[0]));
                }
            }
        });
    }

    private static Shell getShell() {
        return DqpUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection((ISelection)selection);
        if (teiidServer == null) {
            return false;
        }
        this.selectedServer = teiidServer;
        return true;
    }

    public Object execute(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.selectedServer = RuntimeAssistant.getServerFromSelection(currentSelection);
        this.run();
        return null;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

