/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.server;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.IExecutionAdminFactory;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public class SetDefaultServerAction
extends BaseSelectionListenerAction
implements IHandler {
    private ITeiidServer selectedServer;

    public SetDefaultServerAction() {
        super(DqpUiConstants.UTIL.getString("setDefaultServerActionText", new Object[0]));
        if (Platform.isRunning()) {
            this.setToolTipText(DqpUiConstants.UTIL.getString("setDefaultServerActionToolTip", new Object[0]));
            this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/teiid-server-default.png"));
        }
    }

    public void run() {
        if (this.selectedServer == null && !RuntimeAssistant.hasAvailableServers()) {
            String title = DqpUiConstants.UTIL.getString("noServerAvailableTitle", new Object[0]);
            String message = DqpUiConstants.UTIL.getString("noServerAvailableMessage", new Object[0]);
            MessageDialog.openError((Shell)SetDefaultServerAction.getShell(), (String)title, (String)message);
            return;
        }
        if (this.selectedServer == null) {
            this.selectedServer = RuntimeAssistant.selectServer(SetDefaultServerAction.getShell(), true);
            if (RuntimeAssistant.selectServerWasCancelled()) {
                return;
            }
        }
        if (this.selectedServer == null) {
            this.getServerManager().setDefaultServer(null);
            String title = DqpUiConstants.UTIL.getString("defaultServerChangedTitle", new Object[0]);
            String message = DqpUiConstants.UTIL.getString("defaultServerChangedMessage", (Object)"No Default");
            MessageDialog.openInformation((Shell)SetDefaultServerAction.getShell(), (String)title, (String)message);
            return;
        }
        ITeiidServer currentDefaultServer = this.getServerManager().getDefaultServer();
        if (currentDefaultServer != null && currentDefaultServer.equals(this.selectedServer)) {
            String title = DqpUiConstants.UTIL.getString("defaultServerUnchangedTitle", new Object[0]);
            String message = null;
            message = this.getServerManager().getServers().size() == 1 ? DqpUiConstants.UTIL.getString("defaultServerUnchangedMessage1Server", (Object)currentDefaultServer.getParentName()) : DqpUiConstants.UTIL.getString("defaultServerUnchangedMessageMultiServer", (Object)currentDefaultServer.getParentName());
            MessageDialog.openInformation((Shell)SetDefaultServerAction.getShell(), (String)title, (String)message);
            return;
        }
        boolean continueChangingServer = false;
        if (this.changeOfServerVersion() && this.hasOpenEditors() && !(continueChangingServer = MessageDialog.openQuestion((Shell)SetDefaultServerAction.getShell(), (String)DqpUiConstants.UTIL.getString("setDefaultServerActionVersionChangeTitle", new Object[0]), (String)DqpUiConstants.UTIL.getString("setDefaultServerActionVersionChangeMessage", new Object[0])))) {
            return;
        }
        continueChangingServer = false;
        IExecutionAdminFactory.SupportLevel level = ModelerCore.getTeiidSupportLevel((ITeiidServerVersion)this.selectedServer.getServerVersion());
        switch (level) {
            case FULL_SUPPORT: {
                continueChangingServer = true;
                break;
            }
            case NO_SUPPORT: {
                MessageDialog.openError((Shell)SetDefaultServerAction.getShell(), (String)DqpUiConstants.UTIL.getString("setDefaultServerActionNoSupportTitle", new Object[0]), (String)DqpUiConstants.UTIL.getString("setDefaultServerActionNoSupportMessage", new Object[0]));
                continueChangingServer = false;
                break;
            }
            case WORKS: {
                continueChangingServer = MessageDialog.openQuestion((Shell)SetDefaultServerAction.getShell(), (String)DqpUiConstants.UTIL.getString("setDefaultServerActionWorksChangeTitle", new Object[0]), (String)DqpUiConstants.UTIL.getString("setDefaultServerActionWorksChangeMessage", new Object[0]));
            }
        }
        if (!continueChangingServer) {
            return;
        }
        boolean disconnectOldDefault = false;
        if (currentDefaultServer != null && currentDefaultServer.isConnected()) {
            disconnectOldDefault = MessageDialog.openQuestion((Shell)SetDefaultServerAction.getShell(), (String)DqpUiConstants.UTIL.getString("setDefaultServerActionDisconnectOldTitle", new Object[0]), (String)DqpUiConstants.UTIL.getString("setDefaultServerActionDisconnectOldMessage", (Object)currentDefaultServer.getParentName()));
        }
        if (disconnectOldDefault) {
            currentDefaultServer.disconnect();
        }
        this.getServerManager().setDefaultServer(this.selectedServer);
        if (this.selectedServer.isParentConnected()) {
            final ITeiidServer theNewDefaultServer = this.selectedServer;
            UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    theNewDefaultServer.reconnect();
                    if (theNewDefaultServer.getConnectionError() != null) {
                        WidgetUtil.showError((String)theNewDefaultServer.getConnectionError());
                    }
                }
            });
        }
        String title = DqpUiConstants.UTIL.getString("defaultServerChangedTitle", new Object[0]);
        String serverName = this.selectedServer.getParentName();
        String message = DqpUiConstants.UTIL.getString("defaultServerChangedMessage", (Object)serverName);
        MessageDialog.openInformation((Shell)SetDefaultServerAction.getShell(), (String)title, (String)message);
    }

    private ITeiidServerManager getServerManager() {
        return DqpPlugin.getInstance().getServerManager();
    }

    private boolean hasOpenEditors() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (page.getEditorReferences().length > 0) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private boolean changeOfServerVersion() {
        ITeiidServer currentDefaultServer = this.getServerManager().getDefaultServer();
        if (currentDefaultServer == null) {
            return true;
        }
        return !currentDefaultServer.getServerVersion().equals(this.selectedServer.getServerVersion());
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection((ISelection)selection);
        if (teiidServer == null) {
            return false;
        }
        this.selectedServer = teiidServer;
        if (this.getServerManager().getDefaultServer() == null) {
            return true;
        }
        return !this.selectedServer.equals(this.getServerManager().getDefaultServer());
    }

    private static Shell getShell() {
        return DqpUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) {
        this.selectedServer = null;
        this.run();
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

