/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.vdb;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.vdb.ExecuteVdbDialog;
import org.teiid.designer.runtime.ui.vdb.ExecuteVdbWorker;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.vdb.XmiVdb;

public class ExecuteVdbAction
extends Action {
    public static final String THIS_CLASS = I18nUtil.getPropertyPrefix(ExecuteVdbAction.class);
    ExecuteVdbWorker worker;
    Properties designerProperties;

    public ExecuteVdbAction() {
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/run_vdb.gif"));
        this.setToolTipText(DqpUiConstants.UTIL.getString(String.valueOf(THIS_CLASS) + "tooltip", new Object[0]));
        this.worker = new ExecuteVdbWorker();
    }

    public ExecuteVdbAction(Properties properties) {
        this();
        this.designerProperties = properties;
    }

    public void run() {
        if (!this.checkForConnectedServer()) {
            return;
        }
        ExecuteVdbDialog dialog = new ExecuteVdbDialog(this.worker.getShell(), this.designerProperties);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        IFile vdb = dialog.getSelectedVdb();
        if (vdb == null) {
            return;
        }
        try {
            String msg;
            String title;
            Shell shell;
            if (!this.isVdbSyncd(vdb) && !MessageDialog.openQuestion((Shell)(shell = UiUtil.getWorkbenchShellOnlyIfUiThread()), (String)(title = DqpUiConstants.UTIL.getString("VdbNotSyncdDialog.title", new Object[0])), (String)(msg = DqpUiConstants.UTIL.getString("VdbNotSyncdDialog.msg", new Object[0])))) {
                return;
            }
            this.worker.run(vdb);
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog((Throwable)ex);
        }
    }

    private boolean checkForConnectedServer() {
        ITeiidServer teiidServer = ExecuteVdbAction.getServerManager().getDefaultServer();
        if (teiidServer == null || !teiidServer.isConnected()) {
            Shell shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
            String title = DqpUiConstants.UTIL.getString("ActionRequiresServer.title", new Object[0]);
            String msg = DqpUiConstants.UTIL.getString("ActionRequiresServer.msg", new Object[0]);
            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
            return false;
        }
        return true;
    }

    private boolean isVdbSyncd(IFile file) throws Exception {
        XmiVdb vdb = new XmiVdb(file);
        return vdb.isSynchronized();
    }

    private static ITeiidServerManager getServerManager() {
        return DqpPlugin.getInstance().getServerManager();
    }
}

