/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.vdb;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.vdb.VdbUtil;

public class VdbAgeChecker {
    public static boolean doDeploy(IFile vdbFile, ITeiidServerVersion serverVersion) {
        CoreArgCheck.isNotNull((Object)vdbFile, (String)"vdbFile");
        if (serverVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0) && VdbUtil.isVdbTeiidVersion8orGreater((IFile)vdbFile)) {
            String vdbName = FileUtils.getNameWithoutExtension((IResource)vdbFile);
            IWorkbenchWindow window = UiPlugin.getDefault().getCurrentWorkbenchWindow();
            boolean doDeploy = MessageDialog.openQuestion((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString("VdbAgeChecker.oldVdb.title", new Object[0]), (String)DqpUiConstants.UTIL.getString("VdbAgeChecker.oldVdb.message", (Object)vdbName));
            return doDeploy;
        }
        return true;
    }
}

