/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.vdb;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.editor.VdbEditor;

public class VdbRequiresSaveChecker {
    public static boolean insureOpenVdbSaved(IFile vdbFile) {
        IWorkbenchPage page;
        CoreArgCheck.isNotNull((Object)vdbFile, (String)"vdbFile");
        String vdbName = FileUtils.getNameWithoutExtension((IResource)vdbFile);
        IWorkbenchWindow window = UiPlugin.getDefault().getCurrentWorkbenchWindow();
        VdbEditor vdbEditor = null;
        if (window != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IEditorInput input;
                IEditorPart editor = editors[i].getEditor(false);
                if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && vdbFile.equals((Object)((IFileEditorInput)input).getFile())) {
                    if (!(editor instanceof VdbEditor)) break;
                    vdbEditor = (VdbEditor)editor;
                    break;
                }
                ++i;
            }
        }
        if (vdbEditor != null && vdbEditor.isDirty()) {
            final VdbEditor tmpVdbEditor = vdbEditor;
            boolean doSave = MessageDialog.openConfirm((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString("VdbRequiresSaveChecker.unsavedVdb.title", new Object[0]), (String)DqpUiConstants.UTIL.getString("VdbRequiresSaveChecker.unsavedVdb.message", (Object)vdbName));
            if (doSave) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            try {
                                tmpVdbEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (Exception err) {
                                throw new InvocationTargetException(err);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(window.getShell()).run(false, true, op);
                    return true;
                }
                catch (Throwable err) {
                    if (err instanceof InvocationTargetException) {
                        err = ((InvocationTargetException)err).getTargetException();
                    }
                    VdbUiConstants.Util.log(err);
                    return false;
                }
            }
            return false;
        }
        return true;
    }
}

