/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.views.MaskedTextPropertyDescriptor;
import org.teiid.designer.runtime.ui.views.RuntimePropertySourceProvider;

public class ConnectionPropertySource
implements IPropertySource {
    private ITeiidTranslator translator;
    private final Properties initialValues;
    private boolean isEditable = false;
    private RuntimePropertySourceProvider provider;

    public ConnectionPropertySource(ITeiidTranslator translator) {
        this(translator.getProperties());
        this.translator = translator;
    }

    private ConnectionPropertySource(Properties properties) {
        CoreArgCheck.isNotNull((Object)properties, (String)"properties");
        this.initialValues = new Properties(properties);
    }

    public Object getEditableValue() {
        return this.translator;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] result = new IPropertyDescriptor[]{};
        Collection typeDefs = this.translator.getPropertyDefinitions();
        boolean showExpertProps = this.provider.isShowingExpertProperties();
        ArrayList<MaskedTextPropertyDescriptor> temp = new ArrayList<MaskedTextPropertyDescriptor>(typeDefs.size());
        for (final TeiidPropertyDefinition propDefn : typeDefs) {
            final String id = propDefn.getName();
            String displayName = propDefn.getDisplayName();
            MaskedTextPropertyDescriptor descriptor = null;
            if (this.isEditable && propDefn.isModifiable()) {
                descriptor = propDefn.isMasked() ? new MaskedTextPropertyDescriptor(id, displayName) : new TextPropertyDescriptor((Object)id, displayName);
                final ITeiidTranslator validator = this.translator;
                descriptor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        String newValue = (String)value;
                        if (!(newValue != null && newValue.length() != 0 || propDefn.isRequired())) {
                            return null;
                        }
                        return validator.isValidPropertyValue(id, newValue, ITeiidTranslator.TranslatorPropertyType.OVERRIDE);
                    }
                });
            } else if (propDefn.isMasked()) {
                descriptor = new MaskedTextPropertyDescriptor(id, displayName);
                descriptor.setEditable(false);
            } else {
                descriptor = new PropertyDescriptor((Object)id, displayName);
            }
            if (!showExpertProps && propDefn.isAdvanced()) {
                descriptor.setFilterFlags(new String[]{"org.eclipse.ui.views.properties.expert"});
            }
            temp.add(descriptor);
        }
        if (!temp.isEmpty()) {
            result = new IPropertyDescriptor[temp.size()];
            temp.toArray(result);
        }
        result = this.sortPropertyDescriptors(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String propName = (String)id;
        String result = this.translator.getPropertyValue(propName, ITeiidTranslator.TranslatorPropertyType.OVERRIDE);
        if (result == null) {
            return null;
        }
        if (result.length() == 0) {
            return result;
        }
        TeiidPropertyDefinition propDefn = this.translator.getPropertyDefinition(propName, ITeiidTranslator.TranslatorPropertyType.OVERRIDE);
        if (propDefn.isMasked()) {
            StringBuilder sb = new StringBuilder(10);
            int i = 0;
            while (i < 10) {
                sb.append('*');
                ++i;
            }
            return sb.toString();
        }
        return result;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
        TeiidPropertyDefinition propDefn = (TeiidPropertyDefinition)id;
        this.setPropertyValue(id, this.initialValues.getProperty(propDefn.getName()));
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public void setPropertyValue(Object id, Object value) {
        String propName = (String)id;
        try {
            String oldValue = this.translator.getPropertyValue(propName, ITeiidTranslator.TranslatorPropertyType.OVERRIDE);
            String newValue = value.toString();
            this.translator.setPropertyValue(propName, newValue, ITeiidTranslator.TranslatorPropertyType.OVERRIDE);
            this.provider.propertyChanged(new PropertyChangeEvent((Object)this.translator, propName, (Object)oldValue, (Object)newValue));
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log((Throwable)e);
        }
    }

    public void setProvider(RuntimePropertySourceProvider provider) {
        this.provider = provider;
    }

    private IPropertyDescriptor[] sortPropertyDescriptors(IPropertyDescriptor[] theDescriptors) {
        List<IPropertyDescriptor> descriptors = Arrays.asList(theDescriptors);
        Collections.sort(descriptors, new DescriptorSorter());
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    class DescriptorSorter
    implements Comparator {
        DescriptorSorter() {
        }

        public int compare(Object theDescriptor, Object theOtherDescriptor) {
            int result = 0;
            Object tempId = ((IPropertyDescriptor)theDescriptor).getId();
            Object otherTempId = ((IPropertyDescriptor)theOtherDescriptor).getId();
            if (tempId instanceof String && otherTempId instanceof String) {
                String id = (String)tempId;
                String otherId = (String)otherTempId;
                result = id.equals("URL") ? -100 : (id.equals("User") ? (otherId.equals("URL") ? 1 : -50) : (id.equals("Password") ? (otherId.equals("URL") || otherId.equals("User") ? 1 : -25) : (otherId.equals("URL") || otherId.equals("User") || otherId.equals("Password") ? 1 : ((IPropertyDescriptor)theDescriptor).getDisplayName().compareTo(((IPropertyDescriptor)theOtherDescriptor).getDisplayName()))));
            } else {
                result = tempId instanceof Comparable ? ((Comparable)tempId).compareTo(otherTempId) : ((IPropertyDescriptor)theDescriptor).getDisplayName().compareTo(((IPropertyDescriptor)theOtherDescriptor).getDisplayName());
            }
            return result;
        }
    }
}

