/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.runtime.TranslatorTemplate;
import org.teiid.designer.runtime.connection.SourceConnectionBinding;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.views.ConnectionPropertySource;
import org.teiid.designer.ui.properties.ModelPropertySource;

public class RuntimePropertySourceProvider
implements IPropertySourceProvider {
    private boolean connectorsEditable = false;
    private ArrayList<IPropertyChangeListener> listenerList = new ArrayList();
    private boolean showExpertProps = false;

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public IPropertySource getPropertySource(Object object) {
        if (object instanceof TranslatorTemplate) {
            ConnectionPropertySource source = new ConnectionPropertySource((ITeiidTranslator)((TranslatorTemplate)object));
            source.setEditable(this.connectorsEditable);
            source.setProvider(this);
            return source;
        }
        if (object instanceof ITeiidTranslator) {
            ConnectionPropertySource source = new ConnectionPropertySource((ITeiidTranslator)new TranslatorTemplate((ITeiidTranslator)object));
            source.setEditable(this.connectorsEditable);
            source.setProvider(this);
            return source;
        }
        if (object instanceof SourceConnectionBinding) {
            SourceConnectionBinding binding = (SourceConnectionBinding)object;
            Path modelPath = new Path(binding.getModelLocation());
            modelPath = modelPath.append(binding.getModelName());
            ModelResource mr = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace().findModelResource((IPath)modelPath);
            if (mr != null) {
                IFile theResource = null;
                try {
                    theResource = (IFile)mr.getUnderlyingResource();
                }
                catch (ModelWorkspaceException theException) {
                    DqpUiConstants.UTIL.log((Throwable)theException);
                }
                if (theResource != null) {
                    return new ModelPropertySource(theResource);
                }
            }
        }
        return null;
    }

    public boolean isShowingExpertProperties() {
        return this.showExpertProps;
    }

    void propertyChanged(PropertyChangeEvent event) {
        Iterator<IPropertyChangeListener> iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            iter.next().propertyChange(event);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public void setEditable(boolean isEditable) {
        this.setEditable(isEditable, isEditable);
    }

    public void setEditable(boolean connectorBindingsEditable, boolean componentTypesEditable) {
        this.connectorsEditable = connectorBindingsEditable;
    }

    public void setShowExpertProperties(boolean theShowFlag) {
        this.showExpertProps = theShowFlag;
    }
}

