/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.ui.DqpUiConstants;

public class StatusBarUpdater
implements DqpUiConstants,
ISelectionChangedListener {
    private IStatusLineManager statusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.statusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        String statusBarMessage = this.formatMessage(selection);
        this.statusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return UTIL.getString("StatusBarUpdater.num_elements_selected", (Object)String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof ITeiidTranslator) {
                return ((ITeiidTranslator)elem).getName();
            }
            return elem.getClass().getName();
        }
        return "";
    }
}

