/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.actions.ExecuteVDBAction;
import org.teiid.designer.runtime.ui.connection.CreateDataSourceAction;
import org.teiid.designer.runtime.ui.connection.CreateVdbDataSourceAction;
import org.teiid.designer.runtime.ui.dialogs.ClearPreviewArtifactsOptionsDialog;
import org.teiid.designer.runtime.ui.server.DisconnectFromServerAction;
import org.teiid.designer.runtime.ui.server.EditServerAction;
import org.teiid.designer.runtime.ui.server.RefreshServerAction;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.runtime.ui.server.SetDefaultServerAction;
import org.teiid.designer.runtime.ui.views.content.DataSourcesFolder;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.widget.ListMessageDialog;

public class TeiidServerActionProvider
extends CommonActionProvider {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TeiidServerActionProvider.class);
    private ICommonActionExtensionSite actionSite;
    private CommonViewer viewer;
    private IAction collapseAllAction;
    private EditServerAction editServerAction;
    private RefreshServerAction refreshAction;
    private DisconnectFromServerAction disconnectAction;
    private SetDefaultServerAction setDefaultServerAction;
    private Action createDataSourceAction;
    private Action deleteDataSourceAction;
    private Action undeployVdbAction;
    private Action executeVdbAction;
    private IAction clearPreviewArtifactsAction;
    private Action createVdbDataSourceAction;
    private Action showVdbErrorsAction;
    private ISelectionProvider selectionProvider;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            this.viewer = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.selectionProvider = wsSite.getSelectionProvider();
            this.initActions();
        }
    }

    private String getString(String stringId) {
        return DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + stringId, new Object[0]);
    }

    private String getString(String stringId, Object param) {
        return DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + stringId, param);
    }

    private List<Object> getSelectedObjects() {
        ISelection selection = this.selectionProvider.getSelection();
        if (!selection.isEmpty()) {
            return SelectionUtilities.getSelectedObjects((ISelection)selection);
        }
        return Collections.emptyList();
    }

    private void initActions() {
        this.collapseAllAction = new Action(){

            public void run() {
                TeiidServerActionProvider.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/collapseall.gif"));
        this.collapseAllAction.setToolTipText(this.getString("collapseAllAction.tooltip"));
        this.collapseAllAction.setEnabled(true);
        this.deleteDataSourceAction = new Action(this.getString("deleteTeiidDataSourceAction")){

            public void run() {
                List selectedObjs = TeiidServerActionProvider.this.getSelectedObjects();
                for (Object obj : selectedObjs) {
                    ITeiidDataSource tds = RuntimeAssistant.adapt(obj, ITeiidDataSource.class);
                    ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection(TeiidServerActionProvider.this.selectionProvider.getSelection());
                    if (teiidServer == null || !teiidServer.isConnected()) continue;
                    try {
                        teiidServer.deleteDataSource(tds.getName());
                    }
                    catch (Exception e) {
                        DqpUiConstants.UTIL.log(2, (Throwable)e, TeiidServerActionProvider.this.getString("errorDeletingDataSource", tds.getDisplayName()));
                    }
                }
            }
        };
        this.deleteDataSourceAction.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deletefile.gif"));
        this.deleteDataSourceAction.setToolTipText(this.getString("deleteDataSourceAction.tooltip"));
        this.deleteDataSourceAction.setEnabled(true);
        this.undeployVdbAction = new Action(this.getString("undeployVdbAction")){

            public void run() {
                List selectedObjs = TeiidServerActionProvider.this.getSelectedObjects();
                for (Object obj : selectedObjs) {
                    ITeiidVdb vdb = RuntimeAssistant.adapt(obj, ITeiidVdb.class);
                    ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection(TeiidServerActionProvider.this.selectionProvider.getSelection());
                    if (teiidServer == null || !teiidServer.isConnected()) continue;
                    try {
                        teiidServer.undeployVdb(vdb.getName());
                    }
                    catch (Exception e) {
                        DqpUiConstants.UTIL.log(2, (Throwable)e, TeiidServerActionProvider.this.getString("errorUndeployingVdb", vdb.getName()));
                    }
                }
            }
        };
        this.undeployVdbAction.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deletefile.gif"));
        this.undeployVdbAction.setToolTipText(this.getString("undeployVdbAction.tooltip"));
        this.undeployVdbAction.setEnabled(true);
        this.executeVdbAction = new Action(this.getString("executeVdbAction")){

            public void run() {
                List selectedObjs = TeiidServerActionProvider.this.getSelectedObjects();
                for (Object obj : selectedObjs) {
                    ITeiidVdb vdb = RuntimeAssistant.adapt(obj, ITeiidVdb.class);
                    ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection(TeiidServerActionProvider.this.selectionProvider.getSelection());
                    if (teiidServer == null || !teiidServer.isConnected()) continue;
                    try {
                        ExecuteVDBAction.executeVdb(teiidServer, vdb.getName());
                    }
                    catch (Exception e) {
                        DqpUiConstants.UTIL.log(2, (Throwable)e, TeiidServerActionProvider.this.getString("DeployVdbAction.problemDeployingVdbToServer", vdb.getName()));
                    }
                }
            }
        };
        this.executeVdbAction.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/run_vdb.gif"));
        this.executeVdbAction.setToolTipText(this.getString("undeployVdbAction.tooltip"));
        this.executeVdbAction.setEnabled(true);
        final Shell shell = this.actionSite.getViewSite().getShell();
        this.refreshAction = new RefreshServerAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
        this.disconnectAction = new DisconnectFromServerAction(shell.getDisplay());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.disconnectAction);
        this.editServerAction = new EditServerAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.editServerAction);
        this.clearPreviewArtifactsAction = new Action(){

            public void run() {
                ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection(TeiidServerActionProvider.this.selectionProvider.getSelection());
                if (teiidServer != null && teiidServer.isConnected()) {
                    Shell shell = UiUtil.getWorkbenchWindowOnlyIfUiThread().getShell();
                    ClearPreviewArtifactsOptionsDialog dialog = new ClearPreviewArtifactsOptionsDialog(shell);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        String workspaceUuid = ModelerCore.workspaceUuid().toString();
                        if (dialog.doClearVdbs()) {
                            try {
                                ArrayList vdbs = new ArrayList(teiidServer.getVdbs());
                                for (ITeiidVdb vdb : vdbs) {
                                    if (!vdb.getName().contains(workspaceUuid)) continue;
                                    teiidServer.undeployVdb(vdb.getName());
                                }
                            }
                            catch (Exception e) {
                                DqpUiConstants.UTIL.log(2, (Throwable)e, TeiidServerActionProvider.this.getString("errorClearingPreviewVdbs", teiidServer.getDisplayName()));
                            }
                        }
                        if (dialog.doClearDataSources()) {
                            try {
                                ArrayList dataSources = new ArrayList(teiidServer.getDataSources());
                                for (ITeiidDataSource ds : dataSources) {
                                    if (!ds.getName().contains(workspaceUuid)) continue;
                                    teiidServer.deleteDataSource(ds.getName());
                                }
                            }
                            catch (Exception e) {
                                DqpUiConstants.UTIL.log(2, (Throwable)e, TeiidServerActionProvider.this.getString("errorClearingPreviewDataSources", teiidServer.getDisplayName()));
                            }
                        }
                    }
                }
            }
        };
        this.clearPreviewArtifactsAction.setText(this.getString("clearPreviewArtifacts"));
        this.clearPreviewArtifactsAction.setEnabled(true);
        this.createDataSourceAction = new Action(){

            public void run() {
                ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection(TeiidServerActionProvider.this.selectionProvider.getSelection());
                if (teiidServer != null && teiidServer.isConnected()) {
                    CreateDataSourceAction action = new CreateDataSourceAction();
                    action.setTeiidServer(teiidServer);
                    action.setSelection((ISelection)new StructuredSelection());
                    action.setEnabled(true);
                    action.run();
                }
            }
        };
        this.createDataSourceAction.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/sourceBinding.gif"));
        this.createDataSourceAction.setText(this.getString("createDataSourceAction.text"));
        this.createDataSourceAction.setToolTipText(this.getString("createDataSourceAction.tooltip"));
        this.createDataSourceAction.setEnabled(true);
        this.createVdbDataSourceAction = new Action(){

            public void run() {
                ITeiidVdb teiidVdb;
                Object selection;
                List selectedObjs;
                ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection(TeiidServerActionProvider.this.selectionProvider.getSelection());
                if (teiidServer != null && teiidServer.isConnected() && (selectedObjs = TeiidServerActionProvider.this.getSelectedObjects()).size() == 1 && RuntimeAssistant.adapt(selection = selectedObjs.get(0), ITeiidVdb.class) != null && (teiidVdb = RuntimeAssistant.adapt(selection, ITeiidVdb.class)) != null) {
                    CreateVdbDataSourceAction action = new CreateVdbDataSourceAction(teiidVdb.getName());
                    action.setTeiidServer(teiidServer);
                    action.setSelection((ISelection)new StructuredSelection());
                    action.setEnabled(true);
                    action.run();
                }
            }
        };
        this.createVdbDataSourceAction.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/create-vdb-data-source.png"));
        this.createVdbDataSourceAction.setText("Create VDB Data Source");
        this.createVdbDataSourceAction.setToolTipText(this.getString("createDataSourceAction.tooltip"));
        this.createVdbDataSourceAction.setEnabled(true);
        this.showVdbErrorsAction = new Action(this.getString("showVdbErrorsAction")){

            public void run() {
                List selectedObjs = TeiidServerActionProvider.this.getSelectedObjects();
                for (Object obj : selectedObjs) {
                    ITeiidVdb vdb = RuntimeAssistant.adapt(obj, ITeiidVdb.class);
                    ITeiidServer teiidServer = RuntimeAssistant.getServerFromSelection(TeiidServerActionProvider.this.selectionProvider.getSelection());
                    if (teiidServer == null || !teiidServer.isConnected()) continue;
                    try {
                        List errors = vdb.getValidityErrors();
                        ListMessageDialog.openError((Shell)shell, (String)TeiidServerActionProvider.this.getString("deployedVdbHasErrorsTitle"), null, (String)TeiidServerActionProvider.this.getString("deployedVdbHasErrorsMessage", vdb.getName()), (List)errors, null, (boolean)true);
                    }
                    catch (Exception e) {
                        DqpUiConstants.UTIL.log(2, (Throwable)e, TeiidServerActionProvider.this.getString("problemShowingDeployedVdbErrors", vdb.getName()));
                    }
                }
            }
        };
        this.showVdbErrorsAction.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/show-vdb-errors.png"));
        this.showVdbErrorsAction.setEnabled(true);
        this.setDefaultServerAction = new SetDefaultServerAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.setDefaultServerAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.editServerAction);
        this.fillLocalPullDown(actionBars.getMenuManager());
        actionBars.updateActionBars();
    }

    private void fillLocalPullDown(IMenuManager menuMgr) {
        menuMgr.removeAll();
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add(this.clearPreviewArtifactsAction);
    }

    public void fillContextMenu(IMenuManager manager) {
        List<Object> selectedObjs = this.getSelectedObjects();
        manager.removeAll();
        manager.add((IContributionItem)new Separator());
        if (selectedObjs == null || selectedObjs.isEmpty()) {
            manager.add((IAction)this.refreshAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new Separator("additions"));
            return;
        }
        ITeiidServer teiidServer = null;
        if (selectedObjs.size() == 1) {
            Object selection = selectedObjs.get(0);
            if (RuntimeAssistant.adapt(selection, ITeiidDataSource.class) != null) {
                manager.add((IAction)this.createDataSourceAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.deleteDataSourceAction);
                manager.add((IContributionItem)new Separator());
            }
            if (RuntimeAssistant.adapt(selection, ITeiidVdb.class) != null) {
                ITeiidVdb teiidVdb = RuntimeAssistant.adapt(selection, ITeiidVdb.class);
                this.executeVdbAction.setEnabled(teiidVdb.isActive());
                manager.add((IAction)this.executeVdbAction);
                manager.add((IAction)this.createVdbDataSourceAction);
                if (!teiidVdb.getValidityErrors().isEmpty()) {
                    manager.add((IAction)this.showVdbErrorsAction);
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.undeployVdbAction);
                manager.add((IContributionItem)new Separator());
            }
            if ((teiidServer = RuntimeAssistant.adapt(selection, ITeiidServer.class)) != null) {
                boolean teiidServerConnected = teiidServer.isConnected();
                if (this.setDefaultServerAction.isEnabled()) {
                    manager.add((IAction)this.setDefaultServerAction);
                }
                if (teiidServerConnected) {
                    manager.add((IAction)this.disconnectAction);
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.editServerAction);
                manager.add((IContributionItem)new Separator());
                if (teiidServerConnected && selection instanceof DataSourcesFolder) {
                    manager.add((IAction)this.createDataSourceAction);
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add(this.clearPreviewArtifactsAction);
        } else {
            boolean allDataSources = true;
            for (Object obj : selectedObjs) {
                if (RuntimeAssistant.adapt(obj, ITeiidDataSource.class) != null) continue;
                allDataSources = false;
                break;
            }
            if (allDataSources) {
                manager.add((IAction)this.deleteDataSourceAction);
            }
            boolean allVdbs = true;
            for (Object obj : selectedObjs) {
                if (RuntimeAssistant.adapt(obj, ITeiidVdb.class) != null) continue;
                allVdbs = false;
                break;
            }
            if (allVdbs) {
                manager.add((IAction)this.undeployVdbAction);
            }
            manager.add((IAction)this.refreshAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new Separator("additions"));
        }
    }
}

