/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.actions.DeployVdbAction;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class TeiidServerDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private TransferData currentTransfer;
    private ITeiidServer theTargetServer;

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        this.currentTransfer = transferType;
        if (RuntimeAssistant.adapt(target, ITeiidTranslator.class) != null && this.currentTransfer != null && this.isSupportedType(this.currentTransfer)) {
            return Status.OK_STATUS;
        }
        if (RuntimeAssistant.adapt(target, ITeiidServer.class) != null && this.currentTransfer != null && this.isSupportedType(this.currentTransfer)) {
            this.theTargetServer = RuntimeAssistant.adapt(target, ITeiidServer.class);
            return Status.OK_STATUS;
        }
        this.theTargetServer = null;
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        Object theData = aDropTargetEvent.data;
        if (theData instanceof ISelection) {
            List selectedObjects = SelectionUtilities.getSelectedObjects((ISelection)((ISelection)theData));
            for (Object o : selectedObjects) {
                IStatus status;
                if (!(o instanceof IResource) || (status = this.handleResource((IResource)o)) == Status.OK_STATUS) continue;
                return status;
            }
        } else if (theData instanceof IResource[]) {
            IResource[] resources;
            IResource[] iResourceArray = resources = (IResource[])theData;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IStatus status = this.handleResource(resource);
                if (status != Status.OK_STATUS) {
                    return status;
                }
                ++n2;
            }
        } else {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private IStatus handleResource(IResource resource) {
        IFile theFile;
        ModelResource mr = ModelerCore.getModelWorkspace().findModelResource(resource);
        if (mr != null && ModelIdentifier.isPhysicalModelType((ModelResource)mr)) {
            this.currentTransfer = null;
            return Status.OK_STATUS;
        }
        if (resource instanceof IFile && "vdb".equals((theFile = (IFile)resource).getFileExtension())) {
            try {
                DeployVdbAction.deployVdb(this.theTargetServer, theFile);
            }
            catch (Exception e) {
                DqpUiConstants.UTIL.log(4, (Throwable)e, DqpUiConstants.UTIL.getString("TeiidViewDropAdapter.problemDeployingVdbToServer", new Object[]{theFile.getName(), this.theTargetServer}));
            }
        }
        return Status.CANCEL_STATUS;
    }
}

