/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.GuardedBy;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.views.TeiidServerContentProvider;
import org.teiid.designer.runtime.ui.views.content.AbstractTeiidFolder;
import org.teiid.designer.runtime.ui.views.content.ITeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidResourceNode;
import org.teiid.designer.runtime.ui.views.content.TeiidDataNode;
import org.teiid.designer.runtime.ui.views.content.TeiidErrorNode;
import org.teiid.designer.runtime.ui.views.content.TeiidServerContainerNode;

public class TeiidServerLabelProvider
extends ColumnLabelProvider
implements ILightweightLabelDecorator,
IDescriptionProvider {
    private static final long RETRY_DURATION = 2000L;
    private static Pattern pattern = Pattern.compile("[\\\n\\\t]+");
    private ITeiidServerManager serverMgr;
    @GuardedBy(value="offlineServersLock")
    private final Map<ITeiidServer, Long> offlineServerMap = new HashMap<ITeiidServer, Long>();
    private final ReadWriteLock offlineServersLock = new ReentrantReadWriteLock();

    private void addOfflineServer(ITeiidServer teiidServer) {
        try {
            this.offlineServersLock.writeLock().lock();
            this.offlineServerMap.put(teiidServer, System.currentTimeMillis());
        }
        finally {
            this.offlineServersLock.writeLock().unlock();
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        TeiidServerContainerNode node;
        ITeiidServer teiidServer;
        Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        if (this.getServerManager() != null && element instanceof TeiidServerContainerNode && this.isOkToConnect(teiidServer = (node = (TeiidServerContainerNode)element).getTeiidServer()) && !teiidServer.isConnected()) {
            this.addOfflineServer(teiidServer);
        }
    }

    public Image getImage(Object element) {
        if (element instanceof ITeiidResourceNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof TeiidServerContainerNode) {
            return DqpUiPlugin.getDefault().getAnImage("icons/full/ctool16/teiid-server.png");
        }
        if (element instanceof AbstractTeiidFolder) {
            return DqpUiPlugin.getDefault().getAnImage("icons/full/obj16/fldr_obj.gif");
        }
        if (element instanceof TeiidDataNode) {
            return ((TeiidDataNode)element).getImage();
        }
        if (element instanceof TeiidErrorNode) {
            ITeiidServer teiidServer = ((TeiidErrorNode)element).getTeiidServer();
            if (this.getServerManager() != null && teiidServer != null && this.serverMgr.isDefaultServer(teiidServer)) {
                return DqpUiPlugin.getDefault().getAnImage("icons/full/ctool16/teiid-server-disconnected.png");
            }
            return DqpUiPlugin.getDefault().getAnImage("icons/full/ctool16/teiid-server-error.png");
        }
        return null;
    }

    private ITeiidServerManager getServerManager() {
        if (this.serverMgr == null) {
            this.serverMgr = DqpPlugin.getInstance().getServerManager();
        }
        return this.serverMgr;
    }

    public String getText(Object element) {
        if (element instanceof ITeiidContentNode) {
            ITeiidContentNode node = (ITeiidContentNode)element;
            return node.getName();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element == TeiidServerContentProvider.getPending()) {
            return DqpUiConstants.UTIL.getString(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".loading.label", new Object[0]);
        }
        return super.getText(element);
    }

    private synchronized boolean isOkToConnect(ITeiidServer teiidServer) {
        boolean check = false;
        try {
            this.offlineServersLock.readLock().lock();
            check = this.offlineServerMap.containsKey(teiidServer);
        }
        finally {
            this.offlineServersLock.readLock().unlock();
        }
        if (check) {
            try {
                this.offlineServersLock.writeLock().lock();
                if (this.offlineServerMap.containsKey(teiidServer)) {
                    long checkTime = this.offlineServerMap.get(teiidServer);
                    if (System.currentTimeMillis() - checkTime > 2000L) {
                        this.offlineServerMap.remove(teiidServer);
                        return true;
                    }
                    return false;
                }
            }
            finally {
                this.offlineServersLock.writeLock().unlock();
            }
        }
        return true;
    }

    public String getDescription(Object element) {
        String text = element.toString();
        Matcher matcher = pattern.matcher(text);
        return matcher.replaceAll("  ");
    }
}

