/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views.content;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.core.IServer;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.connection.SourceConnectionBinding;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.views.content.AbstractTeiidFolder;
import org.teiid.designer.runtime.ui.views.content.ITeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidResourceNode;

public class TeiidDataNode<V>
implements ITeiidContentNode<AbstractTeiidFolder> {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TeiidDataNode.class);
    private static final String ACTIVE_VDB = DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "activeVdb", new Object[0]);
    private static final String INACTIVE_VDB = DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "inactiveVdb", new Object[0]);
    private AbstractTeiidFolder parentNode;
    private V value;
    private ITeiidServer teiidServer;

    public TeiidDataNode(AbstractTeiidFolder parentNode, V value) {
        this.parentNode = parentNode;
        this.teiidServer = parentNode.getTeiidServer();
        this.value = value;
    }

    @Override
    public IServer getServer() {
        return this.teiidServer.getParent();
    }

    public ITeiidServer getTeiidServer() {
        return this.teiidServer;
    }

    @Override
    public ITeiidResourceNode getParent() {
        return this.parentNode != null ? this.parentNode.getParent() : null;
    }

    @Override
    public AbstractTeiidFolder getContainer() {
        return this.parentNode;
    }

    @Override
    public void dispose() {
        this.parentNode = null;
        this.teiidServer = null;
    }

    @Override
    public String getName() {
        if (this.value instanceof ITeiidDataSource) {
            String nodeName = null;
            if (((ITeiidDataSource)this.value).getDisplayName() != null) {
                nodeName = ((ITeiidDataSource)this.value).getDisplayName();
            }
            nodeName = ((ITeiidDataSource)this.value).getName();
            String jndiName = ((ITeiidDataSource)this.value).getPropertyValue("jndi-name");
            nodeName = jndiName != null && !jndiName.isEmpty() ? String.valueOf(nodeName) + " [JNDI: " + jndiName + "]" : String.valueOf(nodeName) + " [JNDI: java:/" + nodeName + "]";
            return nodeName;
        }
        if (this.value instanceof ITeiidTranslator) {
            return ((ITeiidTranslator)this.value).getName();
        }
        if (this.value instanceof ITeiidVdb) {
            if (((ITeiidVdb)this.value).isDynamicVdb()) {
                return String.valueOf(((ITeiidVdb)this.value).getName()) + " <dynamic>";
            }
            if (((ITeiidVdb)this.value).isDdlFileVdb()) {
                return String.valueOf(((ITeiidVdb)this.value).getName()) + " <ddl>";
            }
            return ((ITeiidVdb)this.value).getName();
        }
        if (this.value instanceof SourceConnectionBinding) {
            SourceConnectionBinding binding = (SourceConnectionBinding)this.value;
            return binding.getModelName();
        }
        return null;
    }

    public String toString() {
        if (this.value instanceof ITeiidDataSource) {
            if (((ITeiidDataSource)this.value).getDisplayName() != null) {
                return ((ITeiidDataSource)this.value).getDisplayName();
            }
            return ((ITeiidDataSource)this.value).getName();
        }
        if (this.value instanceof ITeiidTranslator) {
            return ((ITeiidTranslator)this.value).getName();
        }
        if (this.value instanceof ITeiidVdb) {
            ITeiidVdb vdb = (ITeiidVdb)this.value;
            StringBuilder builder = new StringBuilder();
            builder.append("VDB:\t\t").append(vdb.getName()).append("\nState:\t");
            if (vdb.isActive()) {
                builder.append(ACTIVE_VDB);
            } else {
                builder.append(INACTIVE_VDB);
                for (String error : vdb.getValidityErrors()) {
                    builder.append("\nERROR:\t").append(error);
                }
            }
            int version = ((ITeiidVdb)this.value).getVersion();
            builder.append("\nVersion:").append(version);
            builder.append("\nModels:");
            for (String modelName : vdb.getModelNames()) {
                builder.append("\n\t   ").append(modelName);
            }
            return builder.toString();
        }
        if (this.value instanceof SourceConnectionBinding) {
            SourceConnectionBinding binding = (SourceConnectionBinding)this.value;
            return binding.getModelName();
        }
        return super.toString();
    }

    public Image getImage() {
        if (this.value instanceof ITeiidTranslator) {
            return DqpUiPlugin.getDefault().getAnImage("icons/full/obj16/connectorBinding.gif");
        }
        if (this.value instanceof ITeiidDataSource) {
            return DqpUiPlugin.getDefault().getAnImage("icons/full/ctool16/connection_source.gif");
        }
        if (this.value instanceof ITeiidVdb) {
            ITeiidVdb vdb = (ITeiidVdb)this.value;
            if (vdb.isActive()) {
                if (vdb.getValidityErrors().isEmpty()) {
                    if (vdb.isDynamicVdb()) {
                        return DqpUiPlugin.getDefault().getAnImage("icons/full/obj16/dynamic-vdb.png");
                    }
                    if (vdb.isDdlFileVdb()) {
                        return DqpUiPlugin.getDefault().getAnImage("icons/full/obj16/ddl-vdb.png");
                    }
                    return DqpUiPlugin.getDefault().getAnImage("icons/full/obj16/standard-vdb.png");
                }
                return DqpUiPlugin.getDefault().getAnImage("icons/full/ctool16/active_vdb_with_errors.png");
            }
            return DqpUiPlugin.getDefault().getAnImage("icons/full/ctool16/inactiveDeployedVdb.png");
        }
        if (this.value instanceof SourceConnectionBinding) {
            return DqpUiPlugin.getDefault().getAnImage("icons/full/obj16/sourceModelBinding.png");
        }
        return null;
    }

    public V getValue() {
        return this.value;
    }
}

