/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.vdbs;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.common.util.CompositeProgressMonitor;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.vdb.BasicVdb;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbConstants;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.dynamic.DynamicVdb;

public abstract class AbstractGenerateVdbManager
implements UiConstants,
StringConstants {
    protected static final StringNameValidator nameValidator = new StringNameValidator(1, 255, new char[]{'_', '-', '.'});
    private final AbstractWizard wizard;
    private DynamicVdb dynamicVdb;
    private String version = Integer.toString(1);
    private XmiVdb archiveVdb;
    private IStatus status = Status.OK_STATUS;
    private IContainer outputLocation;
    private String outputVdbFileName;
    private String outputVdbName;
    private Properties conversionOptions = new Properties();
    private boolean overwriteExistingFiles = true;

    public AbstractGenerateVdbManager(AbstractWizard wizard) {
        this.wizard = wizard;
    }

    public DynamicVdb getDynamicVdb() {
        return this.dynamicVdb;
    }

    protected void setDynamicVdb(DynamicVdb dynamicVdb) {
        this.dynamicVdb = dynamicVdb;
    }

    public XmiVdb getArchiveVdb() {
        return this.archiveVdb;
    }

    protected void setArchiveVdb(XmiVdb archiveVdb) {
        this.archiveVdb = archiveVdb;
    }

    public IContainer getOutputLocation() {
        return this.outputLocation;
    }

    public String getOutputVdbName() {
        return this.outputVdbName;
    }

    protected void setOutputLocation(IContainer outputLocation) {
        this.outputLocation = outputLocation;
    }

    protected void refreshOutputLocation() throws CoreException {
        if (this.getOutputLocation() == null) {
            return;
        }
        if (!this.getOutputLocation().exists()) {
            return;
        }
        this.getOutputLocation().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public String getOutputVdbFileName() {
        return this.outputVdbFileName;
    }

    public IFile getDestination() {
        return this.outputLocation.getFile((IPath)new Path(this.getOutputVdbFileName()));
    }

    protected void setOutputVdbFileName(String outputName) {
        this.outputVdbFileName = outputName;
    }

    protected void setOutputVdbName(String outputVdbName) {
        this.outputVdbName = outputVdbName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDynamicVdbXml() throws Exception {
        StringWriter writer = new StringWriter();
        this.dynamicVdb.write((Writer)writer);
        return writer.toString();
    }

    public IStatus getStatus() {
        return this.status;
    }

    protected void setStatus(IStatus status) {
        this.status = status;
    }

    protected void addConversionOption(String name, String value) {
        this.conversionOptions.setProperty(name, value);
    }

    protected String getConversionOption(String key) {
        return this.conversionOptions.getProperty(key);
    }

    protected void setOverwriteExistingFiles(boolean overwrite) {
        this.overwriteExistingFiles = overwrite;
    }

    protected boolean overwriteExistingFiles() {
        return this.overwriteExistingFiles;
    }

    protected void validate() {
        this.setStatus(Status.OK_STATUS);
        String proposedVdbName = this.getOutputVdbFileName();
        String validationMessage = nameValidator.checkValidName(proposedVdbName);
        if (validationMessage != null) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", validationMessage));
            return;
        }
        validationMessage = ModelUtilities.vdbNameReservedValidation((String)proposedVdbName);
        if (validationMessage != null) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", validationMessage));
            return;
        }
        try {
            Integer.parseInt(this.getVersion());
        }
        catch (NumberFormatException numberFormatException) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", NLS.bind((String)Messages.GenerateVdbWizard_validation_versionNotInteger, (Object)this.getVersion())));
            return;
        }
        if (this.getOutputLocation() == null) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Messages.GenerateVdbWizard_validation_targetLocationUndefined));
            return;
        }
        if (!this.getOutputLocation().exists()) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Messages.GenerateVdbWizard_validation_targetLocationNotExist));
            return;
        }
        if (this.getOutputVdbFileName() == null) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Messages.GenerateVdbWizard_validation_vdbFileNameUndefined));
            return;
        }
        IFile destination = this.getDestination();
        if (destination.exists()) {
            int severity = this.overwriteExistingFiles ? 2 : 4;
            this.setStatus((IStatus)new Status(severity, "org.teiid.designer.transformation.ui", Messages.GenerateVdbWizard_validation_targetFileAlreadyExists));
            return;
        }
    }

    protected void generateVdbJob(GeneratorCallback callback) {
        GenerateRunnable runnable = new GenerateRunnable(callback);
        try {
            try {
                this.wizard.getContainer().run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (Exception ex) {
                CoreException coreException = this.toCoreException(ex);
                callback.onCompletion(coreException.getStatus());
                this.wizard.getContainer().updateButtons();
            }
        }
        finally {
            this.wizard.getContainer().updateButtons();
        }
    }

    protected CoreException toCoreException(Throwable throwable) {
        if (throwable instanceof CoreException) {
            return (CoreException)throwable;
        }
        String message = VdbPlugin.UTIL.getStringOrKey(String.valueOf(BasicVdb.class.getSimpleName()) + "." + "vdbExceptionThrown");
        MultiStatus status = new MultiStatus(VdbConstants.PLUGIN_ID, 4, message, null);
        do {
            status.add((IStatus)new Status(4, VdbConstants.PLUGIN_ID, " * " + throwable.getLocalizedMessage()));
        } while ((throwable = throwable.getCause()) != null);
        return new CoreException((IStatus)status);
    }

    protected void write() throws Exception {
        this.refreshOutputLocation();
        IProject project = this.getOutputLocation().getProject();
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
    }

    private class GenerateRunnable
    implements IRunnableWithProgress {
        private final GeneratorCallback callback;
        private final String jobName;

        public GenerateRunnable(GeneratorCallback callback) {
            CoreArgCheck.isNotNull((Object)callback);
            this.callback = callback;
            this.jobName = NLS.bind((String)Messages.GenerateVdbWizard_ConvertJobName, (Object)StringUtilities.fromCamelCase((String)callback.getSourceVdb().getClass().getSimpleName()), (Object)StringUtilities.fromCamelCase((String)callback.getTargetType().getSimpleName()));
        }

        public void run(final IProgressMonitor wizardMonitor) {
            WorkspaceJob job = new WorkspaceJob(this.jobName){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    CompositeProgressMonitor compositeMonitor = new CompositeProgressMonitor(new IProgressMonitor[]{wizardMonitor, monitor});
                    try {
                        compositeMonitor.beginTask(GenerateRunnable.this.jobName, 1);
                        GenerateRunnable.this.callback.execute();
                        compositeMonitor.worked(1);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Exception ex) {
                        throw AbstractGenerateVdbManager.this.toCoreException(ex);
                    }
                    finally {
                        compositeMonitor.done();
                    }
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void aboutToRun(IJobChangeEvent event) {
                    GenerateRunnable.this.callback.aboutToRun();
                }

                public void done(IJobChangeEvent event) {
                    try {
                        AbstractGenerateVdbManager.this.refreshOutputLocation();
                    }
                    catch (CoreException coreException) {}
                    GenerateRunnable.this.callback.onCompletion(event.getResult());
                }
            });
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException ex) {
                CoreException coreException = AbstractGenerateVdbManager.this.toCoreException(ex);
                this.callback.onCompletion(coreException.getStatus());
                job.cancel();
            }
            Runnable swtRunnable = new Runnable(){

                @Override
                public void run() {
                    AbstractGenerateVdbManager.this.wizard.getContainer().updateButtons();
                }
            };
            UiUtil.runInSwtThread((Runnable)swtRunnable, (boolean)true);
        }
    }

    protected abstract class GeneratorCallback<V extends Vdb> {
        private V vdb;

        protected GeneratorCallback() {
        }

        public void aboutToRun() {
        }

        protected void execute() throws Exception {
            this.vdb = this.getSourceVdb().convert(this.getTargetType(), AbstractGenerateVdbManager.this.getDestination(), AbstractGenerateVdbManager.this.conversionOptions);
        }

        public abstract void onCompletion(IStatus var1);

        public abstract Vdb getSourceVdb();

        public abstract Class<V> getTargetType();

        protected final V getResult() {
            return this.vdb;
        }
    }
}

