/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.vdbs;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.runtime.ui.wizards.vdbs.AbstractGenerateVdbManager;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.vdb.VdbConstants;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.dynamic.DynamicVdb;

public class GenerateArchiveVdbManager
extends AbstractGenerateVdbManager {
    private final ResourceRecorder resourceRecorder = new ResourceRecorder();
    private IFile dynamicVdbFile;

    public GenerateArchiveVdbManager(AbstractWizard wizard, IFile dynamicVdbFile) throws Exception {
        super(wizard);
        this.dynamicVdbFile = dynamicVdbFile;
        this.setDynamicVdb(new DynamicVdb(this.dynamicVdbFile));
        String dynName = this.getDynamicVdb().getName();
        this.setOutputVdbName(dynName);
        this.setOutputVdbFileName(String.valueOf(dynName) + ".vdb");
        this.setOutputLocation(this.dynamicVdbFile.getParent());
    }

    public IFile getDynamicVdbFile() {
        return this.dynamicVdbFile;
    }

    public void setDynamicVdbFile(IFile dynamicVdbFile) {
        this.dynamicVdbFile = dynamicVdbFile;
    }

    public boolean isGenerateRequired() {
        return this.getArchiveVdb() == null;
    }

    public void generate() {
        if (!this.isGenerateRequired()) {
            return;
        }
        this.resourceRecorder.clear();
        if (this.getDynamicVdb() == null) {
            return;
        }
        AbstractGenerateVdbManager.GeneratorCallback<XmiVdb> callback = new AbstractGenerateVdbManager.GeneratorCallback<XmiVdb>((AbstractGenerateVdbManager)this){

            public DynamicVdb getSourceVdb() {
                return GenerateArchiveVdbManager.this.getDynamicVdb();
            }

            @Override
            public Class<XmiVdb> getTargetType() {
                return XmiVdb.class;
            }

            @Override
            public void aboutToRun() {
                ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)GenerateArchiveVdbManager.this.resourceRecorder, 59);
            }

            @Override
            public void onCompletion(IStatus status) {
                try {
                    XmiVdb xmiVdb = (XmiVdb)this.getResult();
                    if (status.isOK()) {
                        GenerateArchiveVdbManager.this.setArchiveVdb(xmiVdb);
                    }
                }
                finally {
                    ModelerCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)GenerateArchiveVdbManager.this.resourceRecorder);
                }
            }
        };
        this.generateVdbJob(callback);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getStatus().getSeverity() > 2) {
            return;
        }
        if (this.getOutputVdbFileName().contains(".") && !this.getOutputVdbFileName().toLowerCase().endsWith(".vdb")) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Messages.GenerateArchiveVdbWizard_validation_vdbMissingVdbExtension));
            return;
        }
        if (!this.isGenerateRequired() && this.getArchiveVdb() == null) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Messages.GenerateArchiveVdbWizard_validation_noArchiveVdbGenerated));
            return;
        }
    }

    @Override
    public void write() throws Exception {
        if (this.isGenerateRequired()) {
            return;
        }
        this.getArchiveVdb().save();
        super.write();
    }

    public void cancel() {
        String name = Messages.GenerateArchiveVdbWizard_cancelJobName;
        final Set<IResource> resources = this.resourceRecorder.getResources();
        if (resources.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(name){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                for (IResource resource : resources) {
                    if (resource == null || !resource.exists()) continue;
                    try {
                        resource.delete(true, monitor);
                    }
                    catch (CoreException ex) {
                        if (status == Status.OK_STATUS) {
                            status = new MultiStatus(VdbConstants.PLUGIN_ID, 4, "", null);
                        }
                        ((MultiStatus)status).add(ex.getStatus());
                    }
                }
                return status;
            }
        };
        job.schedule();
    }

    public void dispose() {
        IWorkspace workspace = ModelerCore.getWorkspace();
        if (workspace == null) {
            return;
        }
        workspace.removeResourceChangeListener((IResourceChangeListener)this.resourceRecorder);
    }

    private class ResourceRecorder
    implements IResourceChangeListener {
        private final Set<IResource> resources = new HashSet<IResource>();

        private ResourceRecorder() {
        }

        private void addResource(IResourceDelta resourceDelta) {
            if (resourceDelta == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = resourceDelta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                this.addResource(childDelta);
                ++n2;
            }
            if (1 != resourceDelta.getKind()) {
                return;
            }
            IResource resource = resourceDelta.getResource();
            if (!ModelUtil.isModelFile((IResource)resource)) {
                return;
            }
            if (GenerateArchiveVdbManager.this.getOutputLocation().getFullPath().isPrefixOf(resource.getFullPath())) {
                this.resources.add(resourceDelta.getResource());
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            this.addResource(delta);
        }

        public Set<IResource> getResources() {
            return Collections.unmodifiableSet(this.resources);
        }

        public void clear() {
            this.resources.clear();
        }
    }
}

