/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.vdbs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.runtime.ui.wizards.vdbs.GenerateArchiveVdbManager;
import org.teiid.designer.runtime.ui.wizards.vdbs.style.XmlRegion;
import org.teiid.designer.runtime.ui.wizards.vdbs.style.XmlRegionAnalyzer;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class GenerateArchiveVdbPageOne
extends AbstractWizardPage
implements DqpUiConstants,
StringConstants {
    private Font monospaceFont;
    private StyledText xmlContentsBox;
    private GenerateArchiveVdbManager vdbManager;

    public GenerateArchiveVdbPageOne(GenerateArchiveVdbManager vdbManager) {
        super(GenerateArchiveVdbPageOne.class.getSimpleName(), "");
        this.vdbManager = vdbManager;
        this.setTitle(Messages.GenerateArchiveVdbPageOne_title);
    }

    private Font monospaceFont(Composite composite) {
        if (this.monospaceFont == null) {
            this.monospaceFont = new Font((Device)composite.getDisplay(), "Monospace", 12, 0);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (GenerateArchiveVdbPageOne.this.monospaceFont == null) {
                        return;
                    }
                    GenerateArchiveVdbPageOne.this.monospaceFont.dispose();
                }
            });
        }
        return this.monospaceFont;
    }

    public void createControl(Composite parent) {
        this.monospaceFont(parent);
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        mainPanel.setLayoutData((Object)new GridData());
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        this.setControl((Control)mainPanel);
        Composite summaryPanel = WidgetFactory.createPanel((Composite)mainPanel, (int)16, (int)1);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(10, 10).applyTo(summaryPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)summaryPanel);
        WidgetFactory.createLabel((Composite)summaryPanel, (int)4, (String)Messages.GenerateArchiveVdbPageOne_dynamicVdbFile);
        Label dynamicVdbFileName = new Label(summaryPanel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)dynamicVdbFileName);
        dynamicVdbFileName.setText(this.vdbManager.getDynamicVdbFile().getName());
        dynamicVdbFileName.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        WidgetFactory.createLabel((Composite)summaryPanel, (int)4, (String)Messages.GenerateArchiveVdbPageOne_vdbName);
        Label vdbNameFld = new Label(summaryPanel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)vdbNameFld);
        vdbNameFld.setText(this.vdbManager.getDynamicVdb().getName());
        vdbNameFld.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        this.createXMLDisplayGroup(mainPanel);
        this.setPageComplete(false);
    }

    private List<StyleRange> computeStyleRanges(List<XmlRegion> regions) {
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        if (regions == null) {
            return styleRanges;
        }
        for (XmlRegion xr : regions) {
            StyleRange sr = new StyleRange();
            switch (xr.getXmlRegionType()) {
                case MARKUP: {
                    sr.foreground = Display.getDefault().getSystemColor(6);
                    sr.fontStyle = 1;
                    break;
                }
                case ATTRIBUTE: {
                    sr.foreground = Display.getDefault().getSystemColor(4);
                    break;
                }
                case ATTRIBUTE_VALUE: {
                    sr.foreground = Display.getDefault().getSystemColor(10);
                    break;
                }
                case COMMENT: 
                case MARKUP_VALUE: {
                    sr.foreground = Display.getDefault().getSystemColor(9);
                    break;
                }
                case INSTRUCTION: {
                    sr.foreground = Display.getDefault().getSystemColor(16);
                    break;
                }
                case CDATA: {
                    sr.foreground = Display.getDefault().getSystemColor(2);
                    sr.fontStyle = 1;
                    break;
                }
                case WHITESPACE: {
                    break;
                }
            }
            sr.start = xr.getStart();
            sr.length = xr.getEnd() - xr.getStart();
            styleRanges.add(sr);
        }
        return styleRanges;
    }

    private void setXmlContents(String xml) {
        if (xml == null) {
            xml = "";
        }
        this.xmlContentsBox.setText(xml);
        if (xml.length() > 0) {
            XmlRegionAnalyzer analyzer = new XmlRegionAnalyzer();
            List<XmlRegion> xmlRegions = analyzer.analyzeXml(xml);
            List<StyleRange> styleRanges = this.computeStyleRanges(xmlRegions);
            this.xmlContentsBox.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
        }
    }

    private void createXMLDisplayGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.GenerateArchiveVdbPageOne_vdbXmlContents, (int)1808, (int)1);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(10, 10).applyTo((Composite)theGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)theGroup);
        this.xmlContentsBox = new StyledText((Composite)theGroup, 2826);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.xmlContentsBox);
        this.xmlContentsBox.setEditable(false);
        this.xmlContentsBox.setFont(this.monospaceFont);
    }

    public void setDDL(String ddlText) {
        this.xmlContentsBox.setText(ddlText);
    }

    public String getDDL() {
        return this.xmlContentsBox.getText();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            try {
                String xml = this.vdbManager.getDynamicVdbXml();
                this.setXmlContents(xml);
                this.validatePage();
            }
            catch (Exception ex) {
                this.setErrorMessage(ex.getLocalizedMessage());
                this.setPageComplete(false);
            }
            this.getControl().setVisible(visible);
        }
        super.setVisible(visible);
    }

    private boolean validatePage() {
        WizardUtil.setPageComplete((WizardPage)this, (String)"", (int)0);
        return true;
    }

    public void dispose() {
        super.dispose();
        if (!this.monospaceFont.isDisposed()) {
            this.monospaceFont.dispose();
        }
    }
}

