/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.vdbs;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.runtime.ui.wizards.vdbs.GenerateArchiveVdbManager;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.SingleProjectOrFolderFilter;
import org.teiid.designer.vdb.dynamic.DynamicModel;

public class GenerateArchiveVdbPageTwo
extends AbstractWizardPage
implements DqpUiConstants,
StringConstants {
    private Text ouputVdbNameFld;
    private Text vdbArchiveFileNameFld;
    private Label vdbArchiveLocationText;
    private ListViewer sourceModelsViewer;
    private ListViewer viewModelsViewer;
    private Button ddlAsDescriptionOption;
    private Button generateButton;
    private final GenerateArchiveVdbManager vdbManager;

    public GenerateArchiveVdbPageTwo(GenerateArchiveVdbManager vdbManager) {
        super(GenerateArchiveVdbPageTwo.class.getSimpleName(), "");
        this.vdbManager = vdbManager;
        this.setTitle(Messages.GenerateArchiveVdbPageTwo_title);
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(2, false));
        mainPanel.setLayoutData((Object)new GridData());
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        this.setControl((Control)mainPanel);
        this.createHeaderPanel(mainPanel);
        this.createSourceModelsGroup(mainPanel);
        this.createViewModelsGroup(mainPanel);
        this.createGenerateButtonPanel(mainPanel);
        this.setPageComplete(false);
    }

    private void createHeaderPanel(Composite parent) {
        Group vdbInfoGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.GenerateArchiveVdbPageTwo_vdbDetails, (int)768);
        vdbInfoGroup.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)vdbInfoGroup);
        WidgetFactory.createLabel((Composite)vdbInfoGroup, (int)4, (String)Messages.GenerateArchiveVdbPageTwo_originalVdbName);
        Label vdbNameFld = new Label((Composite)vdbInfoGroup, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)vdbNameFld);
        vdbNameFld.setText(this.vdbManager.getDynamicVdb().getName());
        vdbNameFld.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        Label locationLabel = new Label((Composite)vdbInfoGroup, 0);
        locationLabel.setText(Messages.GenerateArchiveVdbPageTwo_location);
        this.vdbArchiveLocationText = new Label((Composite)vdbInfoGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.vdbArchiveLocationText);
        if (this.vdbManager.getOutputLocation() != null) {
            this.vdbArchiveLocationText.setText(this.vdbManager.getOutputLocation().getFullPath().toString());
        }
        Button browseButton = new Button((Composite)vdbInfoGroup, 8);
        GridData buttonGridData = new GridData();
        browseButton.setLayoutData((Object)buttonGridData);
        browseButton.setText(Messages.GenerateArchiveVdbPageTwo_browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateArchiveVdbPageTwo.this.handleBrowse();
            }
        });
        Label vdbVersionLabel = WidgetFactory.createLabel((Composite)vdbInfoGroup, (String)Messages.GenerateArchiveVdbPageTwo_version);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)vdbVersionLabel);
        final Text vdbVersionText = WidgetFactory.createTextField((Composite)vdbInfoGroup);
        vdbVersionText.setText(Integer.toString(this.vdbManager.getDynamicVdb().getVersion()));
        GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).applyTo((Control)vdbVersionText);
        ((GridData)vdbVersionText.getLayoutData()).widthHint = 40;
        vdbVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateArchiveVdbPageTwo.this.vdbManager.setVersion(vdbVersionText.getText());
                GenerateArchiveVdbPageTwo.this.validatePage();
            }
        });
        WidgetFactory.createLabel((Composite)vdbInfoGroup, (int)4, (String)Messages.GenerateArchiveVdbPageTwo_archiveVdbName);
        this.ouputVdbNameFld = WidgetFactory.createTextField((Composite)vdbInfoGroup, (int)0, (int)768);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.ouputVdbNameFld);
        this.ouputVdbNameFld.setText(this.vdbManager.getOutputVdbName());
        this.ouputVdbNameFld.setToolTipText(Messages.GenerateArchiveVdbPageTwo_archiveVdbNameTooltip);
        this.ouputVdbNameFld.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                GenerateArchiveVdbPageTwo.this.vdbManager.setOutputVdbName(GenerateArchiveVdbPageTwo.this.ouputVdbNameFld.getText());
                GenerateArchiveVdbPageTwo.this.validatePage();
            }
        });
        WidgetFactory.createLabel((Composite)vdbInfoGroup, (int)4, (String)Messages.GenerateArchiveVdbPageTwo_vdbArchiveFileName);
        this.vdbArchiveFileNameFld = WidgetFactory.createTextField((Composite)vdbInfoGroup, (int)0, (int)768);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.vdbArchiveFileNameFld);
        this.vdbArchiveFileNameFld.setText(this.vdbManager.getOutputVdbFileName());
        this.vdbArchiveFileNameFld.setToolTipText(Messages.GenerateArchiveVdbPageTwo_vdbArchiveFileNameTooltip);
        this.vdbArchiveFileNameFld.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                GenerateArchiveVdbPageTwo.this.vdbManager.setOutputVdbFileName(GenerateArchiveVdbPageTwo.this.vdbArchiveFileNameFld.getText());
                GenerateArchiveVdbPageTwo.this.validatePage();
            }
        });
        new Label((Composite)vdbInfoGroup, 258);
        this.ddlAsDescriptionOption = WidgetFactory.createButton((Composite)vdbInfoGroup, (String)Messages.GenerateArchiveVdbPageTwo_ddlAsDescriptionOptionLabel, (int)768, (int)2, (int)32);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.ddlAsDescriptionOption);
        this.ddlAsDescriptionOption.setToolTipText(Messages.GenerateArchiveVdbPageTwo_ddlAsDescriptionOptionTooltip);
        this.ddlAsDescriptionOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateArchiveVdbPageTwo.this.vdbManager.addConversionOption("setDDLAsDescription", Boolean.toString(GenerateArchiveVdbPageTwo.this.ddlAsDescriptionOption.getSelection()));
            }
        });
    }

    private void createSourceModelsGroup(Composite parent) {
        Group group = WidgetFactory.createGroup((Composite)parent, (String)Messages.GenerateArchiveVdbPageTwo_sourceModels, (int)4, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)group);
        GridData gd_2 = new GridData(1808);
        gd_2.widthHint = 220;
        group.setLayoutData((Object)gd_2);
        this.sourceModelsViewer = new ListViewer((Composite)group, 2816);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        this.sourceModelsViewer.getControl().setLayoutData((Object)data);
        Object[] objectArray = this.getSourceModels();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object model = objectArray[n2];
            this.sourceModelsViewer.add(model);
            ++n2;
        }
    }

    private void createViewModelsGroup(Composite parent) {
        Group group = WidgetFactory.createGroup((Composite)parent, (String)Messages.GenerateArchiveVdbPageTwo_viewModels, (int)4, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)group);
        GridData gd_2 = new GridData(1808);
        gd_2.widthHint = 220;
        group.setLayoutData((Object)gd_2);
        this.viewModelsViewer = new ListViewer((Composite)group, 2816);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        this.viewModelsViewer.getControl().setLayoutData((Object)data);
        Object[] objectArray = this.getViewModels();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object model = objectArray[n2];
            this.viewModelsViewer.add(model);
            ++n2;
        }
    }

    private void createGenerateButtonPanel(Composite parent) {
        Composite buttonPanel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)buttonPanel);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(50, 10).applyTo(buttonPanel);
        final Button overwriteExistingOption = WidgetFactory.createButton((Composite)buttonPanel, (String)Messages.GenerateArchiveVdbPageTwo_overwriteFilesOptionLabel, (int)768, (int)2, (int)32);
        overwriteExistingOption.setSelection(this.vdbManager.overwriteExistingFiles());
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)overwriteExistingOption);
        overwriteExistingOption.setToolTipText(Messages.GenerateArchiveVdbPageTwo_overwriteVDBAndModelsOptionTooltip);
        overwriteExistingOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateArchiveVdbPageTwo.this.vdbManager.setOverwriteExistingFiles(overwriteExistingOption.getSelection());
                GenerateArchiveVdbPageTwo.this.validatePage();
            }
        });
        this.generateButton = new Button(buttonPanel, 8);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).grab(true, true).applyTo((Control)this.generateButton);
        this.generateButton.setText(Messages.GenerateVdbButton_Title);
        this.generateButton.setToolTipText(Messages.GenerateVdbButton_Tooltip);
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateArchiveVdbPageTwo.this.vdbManager.generate();
                GenerateArchiveVdbPageTwo.this.generateButton.setEnabled(GenerateArchiveVdbPageTwo.this.vdbManager.isGenerateRequired());
                GenerateArchiveVdbPageTwo.this.validatePage();
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.validatePage();
        }
        super.setVisible(visible);
    }

    private void validatePage() {
        this.vdbManager.validate();
        IStatus status = this.vdbManager.getStatus();
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
            this.generateButton.setEnabled(false);
            return;
        }
        if (status.getSeverity() == 2) {
            this.setErrorMessage(null);
            this.setMessage(Messages.GenerateArchiveVdbPageTwo_clickFinishToSaveVdbAndModels, 0);
            this.setPageComplete(true);
            this.generateButton.setEnabled(this.vdbManager.isGenerateRequired());
        } else {
            this.setErrorMessage(null);
            this.generateButton.setEnabled(this.vdbManager.isGenerateRequired());
            this.setErrorMessage(null);
            this.setMessage(Messages.GenerateArchiveVdbPageTwo_clickFinishToSaveVdbAndModels, 0);
            this.setPageComplete(true);
        }
    }

    Object[] getSourceModels() {
        ArrayList<String> modelNames = new ArrayList<String>();
        for (DynamicModel model : this.vdbManager.getDynamicVdb().getDynamicModels()) {
            if (model.getModelType() != DynamicModel.Type.PHYSICAL) continue;
            modelNames.add(model.getName());
        }
        return modelNames.toArray();
    }

    Object[] getViewModels() {
        ArrayList<String> modelNames = new ArrayList<String>();
        for (DynamicModel model : this.vdbManager.getDynamicVdb().getDynamicModels()) {
            if (model.getModelType() != DynamicModel.Type.VIRTUAL) continue;
            modelNames.add(model.getName());
        }
        return modelNames.toArray();
    }

    void handleBrowse() {
        IProject project = this.vdbManager.getDynamicVdbFile().getProject();
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)project, (ViewerFilter)new SingleProjectOrFolderFilter(project), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.vdbArchiveLocationText != null) {
            this.vdbManager.setOutputLocation(folder);
            this.vdbArchiveLocationText.setText(folder.getFullPath().makeRelative().toString());
        }
        this.validatePage();
    }

    public boolean isPageComplete() {
        if (this.vdbManager.isGenerateRequired()) {
            return false;
        }
        return super.isPageComplete();
    }

    public boolean canFlipToNextPage() {
        if (this.vdbManager.isGenerateRequired()) {
            return false;
        }
        return super.canFlipToNextPage();
    }
}

