/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.vdbs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.runtime.ui.wizards.vdbs.AbstractGenerateVdbManager;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.dynamic.DynamicVdb;

public class GenerateDynamicVdbManager
extends AbstractGenerateVdbManager {
    private IFile archiveVdbFile;
    private boolean excludeSourceMetadata;

    public GenerateDynamicVdbManager(AbstractWizard wizard, IFile archiveVdbFile) throws Exception {
        super(wizard);
        CoreArgCheck.isNotNull((Object)archiveVdbFile);
        this.archiveVdbFile = archiveVdbFile;
        this.setArchiveVdb(new XmiVdb(archiveVdbFile));
        String vdbName = this.getArchiveVdb().getName();
        this.setOutputVdbName(vdbName);
        this.setOutputVdbFileName(String.valueOf(vdbName) + "-vdb.xml");
        this.setOutputLocation(this.archiveVdbFile.getParent());
        this.setVersion(Integer.toString(this.getArchiveVdb().getVersion()));
    }

    private void checkDynamicVdbGenerated() throws Exception {
        if (this.isGenerateRequired()) {
            throw new Exception(Messages.GenerateDynamicVdbWizard_validation_noDynamicVdbGenerated);
        }
    }

    public void generate() {
        if (!this.isGenerateRequired()) {
            return;
        }
        if (this.getArchiveVdb() == null) {
            return;
        }
        this.getArchiveVdb().setExcludeSourceMetadata(this.excludeSourceMetadata);
        AbstractGenerateVdbManager.GeneratorCallback<DynamicVdb> callback = new AbstractGenerateVdbManager.GeneratorCallback<DynamicVdb>((AbstractGenerateVdbManager)this){

            public XmiVdb getSourceVdb() {
                return GenerateDynamicVdbManager.this.getArchiveVdb();
            }

            @Override
            public Class<DynamicVdb> getTargetType() {
                return DynamicVdb.class;
            }

            @Override
            public void onCompletion(IStatus status) {
                if (status.isOK()) {
                    DynamicVdb vdb = (DynamicVdb)this.getResult();
                    vdb.setVersion(Integer.parseInt(GenerateDynamicVdbManager.this.getVersion()));
                    vdb.setName(GenerateDynamicVdbManager.this.getOutputVdbName());
                    GenerateDynamicVdbManager.this.setDynamicVdb(vdb);
                    final IStatus vdbStatus = GenerateDynamicVdbManager.this.getDynamicVdb().getStatus();
                    if (!vdbStatus.isOK()) {
                        UiUtil.runInSwtThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ArrayList<String> messages = new ArrayList<String>();
                                IStatus[] iStatusArray = vdbStatus.getChildren();
                                int n = iStatusArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IStatus status = iStatusArray[n2];
                                    messages.add(status.getMessage());
                                    ++n2;
                                }
                                String title = DqpUiConstants.UTIL.getString("GenerateDynamicVdbManager.generateDynamicVdbStatus", new Object[0]);
                                if (vdbStatus.getSeverity() == 2) {
                                    ListMessageDialog.openWarning((Shell)UiUtil.getWorkbenchShellOnlyIfUiThread(), (String)title, null, (String)DqpUiConstants.UTIL.getString("GenerateDynamicVdbManager.warningsOnExport", new Object[0]), messages, null);
                                } else if (vdbStatus.getSeverity() == 4) {
                                    ListMessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)vdbStatus.getMessage());
                                }
                            }
                        }, (boolean)false);
                    }
                }
            }
        };
        this.generateVdbJob(callback);
    }

    @Override
    public String getDynamicVdbXml() throws Exception {
        this.checkDynamicVdbGenerated();
        return super.getDynamicVdbXml();
    }

    public void export(String directory) throws Exception {
        if (directory == null) {
            return;
        }
        this.checkDynamicVdbGenerated();
        File export = new File(directory, this.getOutputVdbFileName());
        if (export.exists()) {
            if (this.overwriteExistingFiles() && !export.delete()) {
                throw new Exception(VdbPlugin.UTIL.getString("unableToDelete", (Object)export));
            }
            throw new Exception(NLS.bind((String)Messages.GenerateDynamicVdbWizard_exportLocationAlreadyExists, (Object)this.getOutputVdbFileName(), (Object)directory));
        }
        if (!export.createNewFile()) {
            throw new Exception(NLS.bind((String)Messages.GenerateDynamicVdbWizard_exportLocationFailedToCreateFile, (Object)this.getOutputVdbFileName(), (Object)directory));
        }
        FileWriter writer = new FileWriter(export);
        this.getDynamicVdb().write((Writer)writer);
    }

    @Override
    public void write() throws Exception {
        this.checkDynamicVdbGenerated();
        StringWriter writer = new StringWriter();
        this.getDynamicVdb().write((Writer)writer);
        String xml = writer.toString();
        IFile destination = this.getDestination();
        if (this.overwriteExistingFiles() && destination.exists()) {
            destination.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        destination.create((InputStream)inputStream, true, (IProgressMonitor)new NullProgressMonitor());
        super.write();
    }

    public boolean isGenerateRequired() {
        return this.getDynamicVdb() == null;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getStatus().getSeverity() > 2) {
            return;
        }
        if (!this.getOutputVdbFileName().toLowerCase().endsWith("-vdb.xml")) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Messages.GenerateDynamicVdbWizard_validation_vdbMissingXmlExtension));
            return;
        }
        if (!this.isGenerateRequired() && this.getDynamicVdb() == null) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Messages.GenerateDynamicVdbWizard_validation_noDynamicVdbGenerated));
            return;
        }
    }

    @Override
    protected void setOutputVdbFileName(String outputName) {
        if (StringUtilities.areDifferent((String)outputName, (String)this.getOutputVdbFileName())) {
            this.setDynamicVdb(null);
        }
        super.setOutputVdbFileName(outputName);
    }

    @Override
    protected void setOutputVdbName(String outputVdbName) {
        if (StringUtilities.areDifferent((String)outputVdbName, (String)this.getOutputVdbName())) {
            this.setDynamicVdb(null);
        }
        super.setOutputVdbName(outputVdbName);
    }

    @Override
    public void setVersion(String version) {
        if (StringUtilities.areDifferent((String)version, (String)this.getVersion())) {
            this.setDynamicVdb(null);
        }
        super.setVersion(version);
    }

    public boolean isExcludeSourceMetadata() {
        return this.excludeSourceMetadata;
    }

    public void setExcludeSourceMetadata(boolean excludeSourceMetadata) {
        if (excludeSourceMetadata != this.excludeSourceMetadata) {
            if (!this.isGenerateRequired()) {
                this.setDynamicVdb(null);
            }
            this.excludeSourceMetadata = excludeSourceMetadata;
        }
    }
}

