/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.vdbs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.runtime.ui.wizards.vdbs.GenerateDynamicVdbManager;
import org.teiid.designer.runtime.ui.wizards.vdbs.style.XmlRegion;
import org.teiid.designer.runtime.ui.wizards.vdbs.style.XmlRegionAnalyzer;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class GenerateDynamicVdbPageTwo
extends AbstractWizardPage
implements DqpUiConstants,
StringConstants {
    private Font monospaceFont;
    private StyledText xmlContentsBox;
    private Button generateXmlButton;
    private GenerateDynamicVdbManager vdbManager;

    public GenerateDynamicVdbPageTwo(GenerateDynamicVdbManager vdbManager) {
        super(GenerateDynamicVdbPageTwo.class.getSimpleName(), "");
        this.vdbManager = vdbManager;
        this.setTitle(Messages.GenerateDynamicVdbPageTwo_title);
    }

    private Font monospaceFont(Composite composite) {
        if (this.monospaceFont == null) {
            this.monospaceFont = new Font((Device)composite.getDisplay(), "Monospace", 12, 0);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (GenerateDynamicVdbPageTwo.this.monospaceFont == null) {
                        return;
                    }
                    GenerateDynamicVdbPageTwo.this.monospaceFont.dispose();
                }
            });
        }
        return this.monospaceFont;
    }

    public void createControl(Composite parent) {
        this.monospaceFont(parent);
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        mainPanel.setLayoutData((Object)new GridData());
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        this.createButtonPanel(mainPanel);
        this.createXMLDisplayGroup(mainPanel);
        this.setControl((Control)mainPanel);
        this.setPageComplete(false);
    }

    private List<StyleRange> computeStyleRanges(List<XmlRegion> regions) {
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        if (regions == null) {
            return styleRanges;
        }
        for (XmlRegion xr : regions) {
            StyleRange sr = new StyleRange();
            switch (xr.getXmlRegionType()) {
                case MARKUP: {
                    sr.foreground = Display.getDefault().getSystemColor(6);
                    sr.fontStyle = 1;
                    break;
                }
                case ATTRIBUTE: {
                    sr.foreground = Display.getDefault().getSystemColor(4);
                    break;
                }
                case ATTRIBUTE_VALUE: {
                    sr.foreground = Display.getDefault().getSystemColor(10);
                    break;
                }
                case COMMENT: 
                case MARKUP_VALUE: {
                    sr.foreground = Display.getDefault().getSystemColor(9);
                    break;
                }
                case INSTRUCTION: {
                    sr.foreground = Display.getDefault().getSystemColor(16);
                    break;
                }
                case CDATA: {
                    sr.foreground = Display.getDefault().getSystemColor(2);
                    sr.fontStyle = 1;
                    break;
                }
                case WHITESPACE: {
                    break;
                }
            }
            sr.start = xr.getStart();
            sr.length = xr.getEnd() - xr.getStart();
            styleRanges.add(sr);
        }
        return styleRanges;
    }

    private void setXmlContents(String xml) {
        if (xml == null) {
            this.xmlContentsBox.setText("");
        } else {
            this.xmlContentsBox.setText(xml);
            if (xml.length() > 0) {
                XmlRegionAnalyzer analyzer = new XmlRegionAnalyzer();
                List<XmlRegion> xmlRegions = analyzer.analyzeXml(xml);
                List<StyleRange> styleRanges = this.computeStyleRanges(xmlRegions);
                this.xmlContentsBox.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
            }
        }
    }

    private void createXMLDisplayGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.GenerateDynamicVdbPageTwo_fileContents, (int)1808, (int)1);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(10, 10).applyTo((Composite)theGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)theGroup);
        this.xmlContentsBox = new StyledText((Composite)theGroup, 2826);
        GridDataFactory.fillDefaults().grab(true, true).minSize(400, 300).applyTo((Control)this.xmlContentsBox);
        this.xmlContentsBox.setEditable(false);
        this.xmlContentsBox.setFont(this.monospaceFont);
    }

    private void createButtonPanel(Composite parent) {
        Composite buttonPanel = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(10, 10).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.generateXmlButton = new Button(buttonPanel, 8);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)this.generateXmlButton);
        this.generateXmlButton.setText(Messages.GenerateVdbButton_Title);
        this.generateXmlButton.setToolTipText(Messages.GenerateVdbButton_Tooltip);
        this.generateXmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateDynamicVdbPageTwo.this.vdbManager.generate();
                GenerateDynamicVdbPageTwo.this.refreshXml();
                GenerateDynamicVdbPageTwo.this.validatePage();
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.refreshXml();
            this.validatePage();
        }
        super.setVisible(visible);
    }

    private void refreshXml() {
        try {
            String xml = this.vdbManager.getDynamicVdbXml();
            this.setXmlContents(xml);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getLocalizedMessage());
            this.setPageComplete(false);
            this.setXmlContents("");
        }
        this.generateXmlButton.setEnabled(this.vdbManager.isGenerateRequired());
    }

    private void validatePage() {
        this.vdbManager.validate();
        IStatus status = this.vdbManager.getStatus();
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
            return;
        }
        if (status.getSeverity() == 2) {
            this.setErrorMessage(null);
            if (this.vdbManager.isGenerateRequired()) {
                this.setErrorMessage(Messages.GenerateDynamicVdbPageTwo_clickGenerateToCreateVdb);
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                this.setMessage(Messages.GenerateDynamicVdbPageTwo_clickFinishToSaveVdb, 0);
                this.setPageComplete(true);
            }
        } else if (this.vdbManager.isGenerateRequired()) {
            this.setErrorMessage(Messages.GenerateDynamicVdbPageTwo_clickGenerateToCreateVdb);
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setMessage(Messages.GenerateDynamicVdbPageTwo_clickFinishToSaveVdb, 0);
            this.setPageComplete(true);
        }
    }

    public void dispose() {
        super.dispose();
        if (!this.monospaceFont.isDisposed()) {
            this.monospaceFont.dispose();
        }
    }

    public void handleExportDDLToFileSystem() {
        DirectoryDialog dlg = new DirectoryDialog(this.getShell(), 8192);
        dlg.setText(Messages.GenerateDynamicVdbPageTwo_exportXmlDialogTitle);
        String directory = dlg.open();
        if (directory == null) {
            return;
        }
        try {
            this.vdbManager.export(directory);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getLocalizedMessage());
        }
    }
}

