/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.webservices;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.DqpUiStringUtil;
import org.teiid.designer.runtime.ui.wizards.webservices.InternalModelerWarUiConstants;
import org.teiid.designer.runtime.ui.wizards.webservices.RestWarDataserviceModel;
import org.teiid.designer.runtime.ui.wizards.webservices.RestWarDeploymentInfoDialog;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.DesignerProperties;

public abstract class RestWarDeploymentInfoPanel
extends Composite
implements InternalModelerWarUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RestWarDeploymentInfoPanel.class);
    protected static final String INITIAL_MESSAGE = RestWarDeploymentInfoPanel.getString("initialMessage");
    private static final String SECURITY_OPTIONS_GROUP = RestWarDeploymentInfoPanel.getString("securityOptionsGroup");
    public static final String NOSECURITY = RestWarDeploymentInfoPanel.getString("noSecurityButton");
    protected IDialogSettings settings;
    protected RestWarDeploymentInfoDialog dialog;
    protected Text txfWarFileDeploymentLocation;
    protected Text txfContext;
    protected Text txfJNDIName;
    protected Button checkboxIncludeRestJars;
    private Button warBrowseButton;
    private Button restoreDefaultButton;
    protected Text txfSecurityRealm;
    protected Text txfSecurityRole;
    public static final String BASIC = RestWarDeploymentInfoPanel.getString("basicButton");
    protected Button noSecurityButton;
    protected Button basicSecurityButton;
    protected IFile theVdb;
    protected String WARFILELOCATION;
    protected String CONTEXTNAME;
    protected String JNDI_NAME;
    protected String SECURITY_TYPE;
    protected String SECURITY_REALM;
    protected String SECURITY_ROLE;
    private DesignerProperties designerProperties;

    public RestWarDeploymentInfoPanel(Composite parent, RestWarDeploymentInfoDialog dialog, IFile theVdb, Properties designerProperties) {
        super(parent, 0);
        this.dialog = dialog;
        this.theVdb = theVdb;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        this.designerProperties = (DesignerProperties)designerProperties;
        this.init(this);
    }

    protected static String getString(String id) {
        return DqpUiStringUtil.getString(String.valueOf(I18N_PREFIX) + id);
    }

    protected void loadData() {
        try {
            String vdbJndiName;
            String text = this.settings.get(this.WARFILELOCATION) == null ? RestWarDataserviceModel.getInstance().getWarFileLocation() : this.settings.get(this.WARFILELOCATION);
            this.txfWarFileDeploymentLocation.setText(text);
            text = RestWarDataserviceModel.getInstance().getContextName();
            this.txfContext.setText(text);
            text = RestWarDataserviceModel.getInstance().getJndiName();
            this.txfJNDIName.setText(text);
            if (this.designerProperties != null && (vdbJndiName = this.designerProperties.getVdbJndiName()) != null) {
                this.txfJNDIName.setText(vdbJndiName);
            }
            String string = text = this.settings.get(this.SECURITY_TYPE) == null ? RestWarDataserviceModel.getInstance().getSecurityType() : this.settings.get(this.SECURITY_TYPE);
            if (text != null && text.equals(BASIC)) {
                this.basicSecurityButton.setSelection(true);
                this.noSecurityButton.setSelection(false);
                this.basicSecurityButtonSelected();
            } else {
                this.noSecurityButton.setSelection(true);
                this.basicSecurityButton.setSelection(false);
                this.noSecurityButtonSelected();
            }
            String string2 = text = this.settings.get(this.SECURITY_REALM) == null ? RestWarDataserviceModel.getInstance().getSecurityRealm() : this.settings.get(this.SECURITY_REALM);
            if (text != null) {
                this.txfSecurityRealm.setText(text);
            }
            String string3 = text = this.settings.get(this.SECURITY_ROLE) == null ? RestWarDataserviceModel.getInstance().getSecurityRole() : this.settings.get(this.SECURITY_ROLE);
            if (text != null) {
                this.txfSecurityRole.setText(text);
            }
        }
        catch (RuntimeException err) {
            DqpUiConstants.UTIL.log((Throwable)err);
        }
    }

    protected void setDialogMessage(boolean isValid) {
        this.dialog.setMessage(INITIAL_MESSAGE);
        this.dialog.setOkButtonEnable(isValid);
    }

    protected void setDialogMessage(IStatus status) {
        boolean isError = status.getSeverity() == 4;
        int statusCode = status.getSeverity() == 4 ? 3 : status.getSeverity();
        this.dialog.setMessage(INITIAL_MESSAGE);
        if (!status.isOK()) {
            this.dialog.setMessage(status.getMessage(), statusCode);
        }
        this.dialog.setOkButtonEnable(!isError);
    }

    protected abstract void validatePage();

    private void init(Composite parent) {
        this.createDeploymentInfoComposite(parent);
        this.createRestoreDefaultAndIncludeJars(parent);
        this.settings = WidgetUtil.initializeSettings((Object)this, (AbstractUIPlugin)DqpUiPlugin.getDefault());
        this.addListeners();
    }

    private void createDeploymentInfoComposite(Composite parent) {
        String text = RestWarDeploymentInfoPanel.getString("grpPanelText");
        Group pnlContents = WidgetFactory.createGroup((Composite)parent, (String)text, (int)768, (int)3, (int)3);
        this.CONTEXTNAME = RestWarDeploymentInfoPanel.getString("contextLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.CONTEXTNAME);
        this.txfContext = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)2);
        text = RestWarDeploymentInfoPanel.getString("contextTooltip");
        this.txfContext.setToolTipText(text);
        this.JNDI_NAME = RestWarDeploymentInfoPanel.getString("jndiLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.JNDI_NAME);
        this.txfJNDIName = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)2);
        text = RestWarDeploymentInfoPanel.getString("jndiTooltip");
        this.txfJNDIName.setToolTipText(text);
        this.WARFILELOCATION = RestWarDeploymentInfoPanel.getString("warFileSaveLocationLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.WARFILELOCATION);
        this.txfWarFileDeploymentLocation = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)1);
        text = RestWarDeploymentInfoPanel.getString("warFileSaveLocationTooltip");
        this.txfWarFileDeploymentLocation.setToolTipText(text);
        this.warBrowseButton = WidgetFactory.createButton((Composite)pnlContents, (String)InternalUiConstants.Widgets.BROWSE_BUTTON);
        this.warBrowseButton.setText(RestWarDeploymentInfoPanel.getString("changeButtonText"));
        this.warBrowseButton.setToolTipText(text);
        this.warBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                RestWarDeploymentInfoPanel.this.handleWarBrowseSourceSelected();
            }
        });
        Group securityOptionsGroup = WidgetFactory.createGroup((Composite)pnlContents, (String)SECURITY_OPTIONS_GROUP, (int)768, (int)3, (int)3);
        CLabel label3 = new CLabel((Composite)securityOptionsGroup, 64);
        label3.setText("When using HTTPBasic security, a local Teiid connection is required using the PassthroughAuthentication property.");
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 3;
        label3.setLayoutData((Object)gridData3);
        this.noSecurityButton = WidgetFactory.createRadioButton((Composite)securityOptionsGroup, (String)NOSECURITY);
        this.noSecurityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestWarDeploymentInfoPanel.this.noSecurityButtonSelected();
            }
        });
        this.noSecurityButton.setSelection(true);
        this.basicSecurityButton = WidgetFactory.createRadioButton((Composite)securityOptionsGroup, (String)BASIC);
        this.basicSecurityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestWarDeploymentInfoPanel.this.basicSecurityButtonSelected();
            }
        });
        new CLabel((Composite)securityOptionsGroup, 0);
        this.SECURITY_REALM = RestWarDeploymentInfoPanel.getString("securityRealmLabel");
        WidgetFactory.createLabel((Composite)securityOptionsGroup, (int)32, (int)1, (String)this.SECURITY_REALM);
        this.txfSecurityRealm = WidgetFactory.createTextField((Composite)securityOptionsGroup, (int)768, (int)2);
        text = RestWarDeploymentInfoPanel.getString("securityRealmTooltip");
        this.txfSecurityRealm.setToolTipText(text);
        this.txfSecurityRealm.setEnabled(false);
        this.SECURITY_ROLE = RestWarDeploymentInfoPanel.getString("securityRoleLabel");
        WidgetFactory.createLabel((Composite)securityOptionsGroup, (int)32, (int)1, (String)this.SECURITY_ROLE);
        this.txfSecurityRole = WidgetFactory.createTextField((Composite)securityOptionsGroup, (int)768, (int)2);
        text = RestWarDeploymentInfoPanel.getString("securityRoleTooltip");
        this.txfSecurityRole.setToolTipText(text);
        this.txfSecurityRole.setEnabled(false);
    }

    private void createRestoreDefaultAndIncludeJars(Composite parent) {
        Composite restoreDefault = WidgetFactory.createPanel((Composite)parent, (int)0, (int)768, (int)1);
        GridLayout layout = new GridLayout();
        restoreDefault.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.checkboxIncludeRestJars = WidgetFactory.createCheckBox((Composite)restoreDefault, (String)RestWarDeploymentInfoPanel.getString("includeJars.text"), (int)768, (boolean)true);
        String text = RestWarDeploymentInfoPanel.getString("includeJars.tooltip");
        this.checkboxIncludeRestJars.setToolTipText(text);
        this.checkboxIncludeRestJars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                RestWarDeploymentInfoPanel.this.handleIncludeJarsSelected();
            }
        });
        text = RestWarDeploymentInfoPanel.getString("restoreDefaultButtonText");
        this.restoreDefaultButton = WidgetFactory.createButton((Composite)restoreDefault, (String)text, (int)3);
        text = RestWarDeploymentInfoPanel.getString("restoreDefaultTooltip");
        this.restoreDefaultButton.setToolTipText(text);
        this.restoreDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestWarDeploymentInfoPanel.this.restoreDefaultButtonPressed();
            }
        });
    }

    private void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                RestWarDeploymentInfoPanel.this.validatePage();
                RestWarDeploymentInfoPanel.this.setWarFileNameInDialog();
            }
        };
        this.txfWarFileDeploymentLocation.addModifyListener(modifyListener);
        this.txfContext.addModifyListener(modifyListener);
        this.txfJNDIName.addModifyListener(modifyListener);
        this.txfSecurityRealm.addModifyListener(modifyListener);
        this.txfSecurityRole.addModifyListener(modifyListener);
    }

    protected void setWarFileNameInDialog() {
        this.dialog.setWarFileName(this.txfContext.getText());
    }

    void restoreDefaultButtonPressed() {
        this.txfWarFileDeploymentLocation.setText(RestWarDataserviceModel.getInstance().getWarFilenameDefault());
        this.txfContext.setText(RestWarDataserviceModel.getInstance().getContextNameDefault());
        this.txfJNDIName.setText(RestWarDataserviceModel.getInstance().getJndiNameDefault());
    }

    void noSecurityButtonSelected() {
        if (this.noSecurityButton.getSelection()) {
            RestWarDataserviceModel.getInstance().setSecurityTypeDefault(NOSECURITY);
            this.txfSecurityRealm.setText("");
            this.txfSecurityRealm.setEnabled(false);
            this.txfSecurityRole.setText("");
            this.txfSecurityRole.setEnabled(false);
        }
        this.validatePage();
    }

    void basicSecurityButtonSelected() {
        if (this.basicSecurityButton.getSelection()) {
            RestWarDataserviceModel.getInstance().setSecurityTypeDefault(BASIC);
            this.txfSecurityRealm.setText("teiid-security");
            RestWarDataserviceModel.getInstance().setSecurityRealmDefault("teiid-security");
            this.txfSecurityRealm.setEnabled(true);
            this.txfSecurityRole.setText("MyRole");
            RestWarDataserviceModel.getInstance().setSecurityRoleDefault("MyRole");
            this.txfSecurityRole.setEnabled(true);
        }
        this.validatePage();
    }

    void handleWarBrowseSourceSelected() {
        DirectoryDialog folderDialog = new DirectoryDialog(this.getShell());
        folderDialog.setText(RestWarDeploymentInfoPanel.getString("warTitle"));
        folderDialog.setMessage(RestWarDeploymentInfoPanel.getString("warMessage"));
        folderDialog.setFilterPath(this.txfWarFileDeploymentLocation.getText());
        String selectedUnit = folderDialog.open();
        if (selectedUnit != null) {
            this.txfWarFileDeploymentLocation.setText(selectedUnit);
        }
    }

    void handleIncludeJarsSelected() {
        RestWarDataserviceModel.getInstance().setIncludeJars(this.checkboxIncludeRestJars.getSelection());
    }
}

