/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.webservices;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.wizards.webservices.InternalModelerWarUiConstants;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDataserviceModel;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDeploymentInfoDataPage;
import org.teiid.designer.runtime.ui.wizards.webservices.util.WebArchiveBuilder;
import org.teiid.designer.runtime.ui.wizards.webservices.util.WebArchiveBuilderFactory;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.webservice.WebServicePlugin;

public class WarDeploymentInfoDialog
extends TitleAreaDialog
implements InternalModelerWarUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(WarDeploymentInfoDialog.class);
    private static final String TITLE = WarDeploymentInfoDialog.getString("title");
    private static final String MESSAGE_TITLE = WarDeploymentInfoDialog.getString("messageTitle");
    private static final String INITIAL_MESSAGE = WarDeploymentInfoDialog.getString("initialMessage");
    private static final String OVERWRITE_TARGET_WAR_TITLE = WarDeploymentInfoDialog.getString("overwriteTargetWar.title");
    private static final String OVERWRITE_TARGET_WAR_MESSAGE = WarDeploymentInfoDialog.getString("overwriteTargetWar.message");
    private static final String CREATING_WAR_FILE_MESSAGE_ID = "WarDeploymentInfoDialog.creatingWarFileMessage";
    private Button okButton;
    private WarDeploymentInfoDataPage warDeploymentInfoDataPage;
    private IFile theVdb;
    private IStatus deploymentStatus;
    private String warFileName;
    private IStatus initialStatus;

    public WarDeploymentInfoDialog(Shell parent, IFile theVdb, IStatus initialStatus) {
        super(parent);
        ImageDescriptor id = DqpUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/warFile.jpg");
        if (id != null) {
            WarDeploymentInfoDialog.setDefaultImage((Image)id.createImage());
        }
        this.theVdb = theVdb;
        this.initialStatus = initialStatus;
        this.deploymentStatus = new Status(0, "org.teiid.designer.dqp.ui", 0, "WAR file created successfully", null);
    }

    public void setOkButtonEnable(boolean isEnable) {
        if (this.okButton != null) {
            this.okButton.setEnabled(isEnable);
        }
    }

    protected void setShellStyle(int theNewShellStyle) {
        super.setShellStyle(theNewShellStyle | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808, (int)1);
        this.warDeploymentInfoDataPage = null;
        this.warDeploymentInfoDataPage = new WarDeploymentInfoDataPage(contents, this, this.theVdb, this.initialStatus);
        ImageDescriptor id = DqpUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/warFile.jpg");
        if (id != null) {
            this.setTitleImage(id.createImage());
        }
        this.setTitle(MESSAGE_TITLE);
        this.setMessage(INITIAL_MESSAGE);
        return contents;
    }

    protected static String getString(String id) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.loadDefault();
    }

    protected void okPressed() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        WarDeploymentInfoDialog.this.execute(monitor);
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, op);
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            DqpUiConstants.UTIL.log(err);
        }
    }

    public int open() {
        int rc = super.open();
        if (rc != 1) {
            return this.deploymentStatus.getSeverity();
        }
        return rc;
    }

    void execute(IProgressMonitor monitor) {
        try {
            WebArchiveBuilder webArchiveBuilder = WebArchiveBuilderFactory.create();
            monitor.worked(25);
            boolean createWar = true;
            boolean targetExists = webArchiveBuilder.targetWarFileExists(WarDataserviceModel.getInstance().getProperties());
            if (targetExists) {
                createWar = MessageDialog.openQuestion((Shell)this.getShell(), (String)OVERWRITE_TARGET_WAR_TITLE, (String)OVERWRITE_TARGET_WAR_MESSAGE);
            }
            if (createWar) {
                monitor.beginTask(DqpUiConstants.UTIL.getString(CREATING_WAR_FILE_MESSAGE_ID, (Object)this.warFileName), 100);
                this.deploymentStatus = webArchiveBuilder.createWebArchive(WarDataserviceModel.getInstance().getProperties(), monitor);
                DqpUiConstants.UTIL.log(this.deploymentStatus);
                this.setMessage(this.deploymentStatus.getMessage(), this.deploymentStatus.getSeverity());
                super.okPressed();
            }
        }
        catch (RuntimeException err) {
            DqpUiConstants.UTIL.log((Throwable)err);
            this.setMessage("Error while generating the WAR file check log for detail message.", 3);
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void loadDefault() {
        this.loadWarFileLocationDefault();
        this.loadContextNameDefault();
        this.loadHostNameDefault();
        this.loadPortDefault();
        this.loadTnsDefault();
        this.loadJndiNameDefault();
        this.loadSecurityTypeDefault();
        this.loadUseMTOMDefault();
        WarDataserviceModel.getInstance().setVdbFile(this.theVdb);
        this.warDeploymentInfoDataPage.loadData();
        this.warDeploymentInfoDataPage.setWarFileNameInDialog();
    }

    private void loadWarFileLocationDefault() {
        try {
            String warDir = WebServicePlugin.getDefaultWarFileSaveLocation();
            WarDataserviceModel.getInstance().setWarFilenameDefault(warDir);
        }
        catch (Throwable theThrowable) {
            DqpUiConstants.UTIL.log(theThrowable);
        }
    }

    private void loadUseMTOMDefault() {
        try {
            WarDataserviceModel.getInstance().setUseMtom(false);
        }
        catch (Throwable theThrowable) {
            DqpUiConstants.UTIL.log(theThrowable);
        }
    }

    private void loadContextNameDefault() {
        try {
            WarDataserviceModel.getInstance().setContextNameDefault("");
            if (this.theVdb == null) {
                WarDataserviceModel.getInstance().setContextNameDefault("");
                return;
            }
            String name = this.theVdb.getName().substring(0, this.theVdb.getName().lastIndexOf("."));
            WarDataserviceModel.getInstance().setContextNameDefault(name);
        }
        catch (Throwable theThrowable) {
            DqpUiConstants.UTIL.log(theThrowable);
        }
    }

    private void loadHostNameDefault() {
        WarDataserviceModel.getInstance().setHostNameDefault("localhost");
    }

    private void loadPortDefault() {
        WarDataserviceModel.getInstance().setPortDefault("8080");
    }

    private void loadTnsDefault() {
        WarDataserviceModel.getInstance().setTnsDefault("http://teiid.org");
    }

    private void loadJndiNameDefault() {
        WarDataserviceModel.getInstance().setJndiNameDefault("{REPLACE_WITH_VDB_JNDI_NAME}");
    }

    private void loadSecurityTypeDefault() {
        WarDataserviceModel.getInstance().setSecurityTypeDefault("none");
    }

    public void setWarFileName(String name) {
        this.warFileName = name;
    }

    public String getWarFileName() {
        return this.warFileName;
    }
}

