/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.namedobject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.designer.util.CoreStringUtil;

public abstract class BaseID
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELIMITER = new String(new char[]{'.'});
    public static final String WILDCARD = "*";
    protected String fullName;
    private int hashCode;
    protected transient List atomicNames;

    public BaseID(String fullName) {
        this(fullName, 15);
    }

    protected BaseID(String fullName, int checkLevel) {
        if (fullName == null) {
            throw new IllegalArgumentException("ERR.003.018.0001");
        }
        if (fullName.trim().length() == 0) {
            throw new IllegalArgumentException("ERR.003.018.0002");
        }
        this.fullName = fullName;
        this.updateHashCode();
    }

    public final String getFullName() {
        return this.fullName;
    }

    public String getName() {
        int nameComponentCount = this.getNameComponents().size();
        return (String)this.getNameComponents().get(nameComponentCount - 1);
    }

    public final String getNameComponent(int index) {
        return (String)this.getNameComponents().get(index);
    }

    public List getNameComponents() {
        if (this.atomicNames == null) {
            if (this.fullName.indexOf(46) != -1) {
                this.atomicNames = CoreStringUtil.split((String)this.fullName, (String)DELIMITER);
            } else {
                this.atomicNames = new ArrayList(1);
                this.atomicNames.add(this.fullName);
            }
            this.atomicNames = Collections.unmodifiableList(this.atomicNames);
        }
        return this.atomicNames;
    }

    public final int size() {
        return this.getNameComponents().size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaseID) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            BaseID that = (BaseID)obj;
            if (this.getClass() != that.getClass()) {
                return false;
            }
            return this.fullName.equalsIgnoreCase(that.fullName);
        }
        return false;
    }

    public int compareTo(Object obj) {
        BaseID that = (BaseID)obj;
        if (obj == null) {
            throw new IllegalArgumentException("ERR.003.018.0003");
        }
        int diff = this.hashCode() - that.hashCode();
        if (diff != 0) {
            return diff;
        }
        if (this.getClass() != that.getClass()) {
            diff = this.getClass().hashCode() - that.getClass().hashCode();
            return diff;
        }
        return this.fullName.compareToIgnoreCase(that.fullName);
    }

    public int compareToByName(Object obj) {
        BaseID that = (BaseID)obj;
        if (obj == null) {
            throw new IllegalArgumentException("Attempt to compare null");
        }
        return this.fullName.compareToIgnoreCase(that.fullName);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return this.fullName;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getParentFullName() {
        int lastDelim = this.fullName.lastIndexOf(46);
        if (lastDelim == -1) {
            return null;
        }
        return this.fullName.substring(0, lastDelim);
    }

    public boolean hasParent() {
        boolean result = false;
        if (this.atomicNames != null) {
            result = this.atomicNames.size() > 1;
        } else {
            int lastDelim = this.fullName.indexOf(46);
            if (lastDelim != -1) {
                result = true;
            }
        }
        return result;
    }

    protected final void updateHashCode() {
        this.hashCode = this.computeHashCode();
    }

    protected int computeHashCode() {
        return this.fullName.toLowerCase().hashCode();
    }
}

