/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.namedobject;

import java.text.StringCharacterIterator;
import org.teiid.designer.common.namedobject.BaseID;

public class IDVerifier {
    public static final char UNDERSCORE_CHARACTER = '_';
    public static final char DELIMITER_CHARACTER = '.';
    public static final int NONE = 0;
    public static final int ZERO_LENGTH_FULL_NAME = 1;
    public static final int FIRST_CHARACTER_IS_NOT_A_LETTER = 2;
    public static final int CONTAINS_INVALID_CHARACTER = 4;
    public static final int CONTAINS_SPACE = 8;
    public static final int ALL = 15;

    public static boolean isValid(BaseID id) {
        if (id == null) {
            throw new IllegalArgumentException("ERR.003.018.0006");
        }
        return IDVerifier.performCheck(id.getFullName()) == 0;
    }

    public static int performCheck(BaseID id) {
        if (id == null) {
            throw new IllegalArgumentException("ERR.003.018.0007");
        }
        return IDVerifier.performCheck(id.getFullName());
    }

    public static int performCheck(String fullName) {
        return IDVerifier.performCheck(fullName, 15);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int performCheck(String fullName, int levels) {
        if (fullName.length() == 0 && (levels & 1) != 0) {
            return 1;
        }
        StringCharacterIterator iter = new StringCharacterIterator(fullName);
        char c = iter.first();
        if ((levels & 2) != 0 && !Character.isLetter(c)) {
            return 2;
        }
        if ((levels & 8) != 0) {
            if ((levels & 4) == 0) {
                if (fullName.indexOf(32) == -1) return 0;
                return 8;
            }
            do {
                if (Character.isSpaceChar(c)) {
                    return 8;
                }
                if (Character.isLetterOrDigit(c) || c == '_' || c == '.') continue;
                return 4;
            } while ((c = iter.next()) != '\uffff');
            return 0;
        }
        if ((levels & 4) == 0) return 0;
        do {
            if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c) || c == '_' || c == '.') continue;
            return 4;
        } while ((c = iter.next()) != '\uffff');
        return 0;
    }
}

