/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class ByteArrayHelper {
    public static final int CHUNK_SIZE = 32000;

    public static byte[] toByteArray(File file) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            byte[] byArray = ByteArrayHelper.toByteArray(fis);
            return byArray;
        }
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        return ByteArrayHelper.toByteArray(stream, 32000);
    }

    public static byte[] toByteArray(InputStream stream, int chunkSize) throws IOException {
        byte[] data = null;
        ArrayList<byte[]> dataArrays = null;
        data = new byte[chunkSize];
        int pos = 0;
        int finalSize = 0;
        while (stream.available() > 0) {
            int n = stream.read(data, pos, data.length - pos);
            if (n >= 0) {
                pos += n;
            }
            if (data.length - pos != 0) continue;
            if (dataArrays == null) {
                dataArrays = new ArrayList<byte[]>();
            }
            dataArrays.add(data);
            data = new byte[chunkSize];
            pos = 0;
            finalSize += chunkSize;
        }
        byte[] result = new byte[finalSize += pos];
        int offSet = 0;
        if (dataArrays != null) {
            Iterator i = dataArrays.iterator();
            byte[] tempArray = null;
            while (i.hasNext()) {
                tempArray = (byte[])i.next();
                System.arraycopy(tempArray, 0, result, offSet, chunkSize);
                offSet += chunkSize;
            }
        }
        System.arraycopy(data, 0, result, offSet, pos);
        return result;
    }

    public static InputStream toInputStream(byte[] data) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream isContent = new BufferedInputStream(bais);
        return isContent;
    }
}

