/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.vdb;

import org.teiid.designer.common.vdb.VdbHeader;
import org.teiid.designer.common.vdb.VdbModelInfo;
import org.teiid.designer.common.vdb.VdbNonModelInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TerminatingVdbHeaderContentHandler
extends DefaultHandler {
    public static final String HEADER_FOUND_EXCEPTION_MESSAGE = "HeaderFoundException";
    public static final String XMI_NOT_FOUND_EXCEPTION_MESSAGE = "XMINotFoundException";
    private static final String XMI_TAG_NAME = "XMI";
    private static final String VIRTUAL_DATABASE_TAG_NAME = "VirtualDatabase";
    private static final String XMI_VERSION_0020_ATTRIBUTE_NAME = "xmi:version";
    private static final String XMI_VERSION_0011_ATTRIBUTE_NAME = "xmi.version";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String MODEL_PATH_ATTRIBUTE_NAME = "path";
    private static final String MODEL_LOC_ATTRIBUTE_NAME = "modelLocation";
    private static final String UUID_ATTRIBUTE_NAME = "uuid";
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    private static final String SEVERITY_ATTRIBUTE_NAME = "severity";
    private static final String MODEL_TYPE_ATTRIBUTE_NAME = "modelType";
    private static final String PRIMARY_URI_ATTRIBUTE_NAME = "primaryMetamodelUri";
    private static final String VISIBLE_ATTRIBUTE_NAME = "visible";
    private static final String CHECKSUM_ATTRIBUTE_NAME = "checksum";
    private static final String PRODUCER_NAME_ATTRIUBTE_NAME = "producerName";
    private static final String PRODUCER_VERSION_ATTRIUBTE_NAME = "producerVersion";
    private static final String TIME_CHANGED_ATTRIUBTE_NAME = "timeLastChanged";
    private static final String TIME_PRODUCED_ATTRIUBTE_NAME = "timeLastProduced";
    private static final String MODELS_TAG_NAME = "models";
    private static final String NON_MODELS_TAG_NAME = "nonModels";
    private static final String MARKERS_TAG_NAME = "markers";
    private boolean foundXmiStartElement = false;
    private boolean foundVdbStartElement = false;
    private boolean foundVdbEndElement = false;
    private VdbHeader header;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase(XMI_TAG_NAME)) {
            this.processAttributes(atts);
            this.foundXmiStartElement = true;
        } else if (localName.equalsIgnoreCase(VIRTUAL_DATABASE_TAG_NAME)) {
            this.processVdbAttributes(atts);
            this.foundVdbStartElement = true;
        } else if (localName.equalsIgnoreCase(MARKERS_TAG_NAME)) {
            this.processMarkerAttributes(atts);
        } else if (localName.equalsIgnoreCase(MODELS_TAG_NAME) && this.foundVdbStartElement) {
            this.processModelRefAttributes(atts);
        } else if (localName.equalsIgnoreCase(NON_MODELS_TAG_NAME)) {
            this.processNonModelRefAttributes(atts);
        }
        this.checkForCompletion();
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkForCompletion();
        if (localName.equals(VIRTUAL_DATABASE_TAG_NAME)) {
            this.foundVdbEndElement = true;
        }
        super.endElement(namespaceURI, localName, qName);
    }

    public VdbHeader getVdbHeader() {
        if (this.header == null) {
            this.header = new VdbHeader();
        }
        return this.header;
    }

    private void checkForCompletion() throws SAXException {
        if (!this.foundXmiStartElement && !this.foundVdbStartElement) {
            throw new SAXException(XMI_NOT_FOUND_EXCEPTION_MESSAGE);
        }
        if (this.foundVdbStartElement && this.foundVdbEndElement) {
            throw new SAXException(HEADER_FOUND_EXCEPTION_MESSAGE);
        }
    }

    private void processAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String value = atts.getValue(i);
            String qname = atts.getQName(i);
            if (qname.equalsIgnoreCase(XMI_VERSION_0020_ATTRIBUTE_NAME)) {
                this.getVdbHeader().setXmiVersion(value);
            } else if (qname.equalsIgnoreCase(XMI_VERSION_0011_ATTRIBUTE_NAME)) {
                this.getVdbHeader().setXmiVersion(value);
            }
            ++i;
        }
    }

    private void processVdbAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            String qname = atts.getQName(i);
            if (name.equalsIgnoreCase(UUID_ATTRIBUTE_NAME)) {
                this.getVdbHeader().setUUID(value);
            } else if (name.equalsIgnoreCase(NAME_ATTRIBUTE_NAME)) {
                this.getVdbHeader().setName(value);
            } else if (name.equalsIgnoreCase(DESCRIPTION_ATTRIBUTE_NAME)) {
                this.getVdbHeader().setDescription(value);
            } else if (name.equalsIgnoreCase(SEVERITY_ATTRIBUTE_NAME)) {
                this.getVdbHeader().setSeverity(value.toUpperCase());
            } else if (name.equalsIgnoreCase(PRODUCER_NAME_ATTRIUBTE_NAME)) {
                this.getVdbHeader().setProducerName(value);
            } else if (name.equalsIgnoreCase(PRODUCER_VERSION_ATTRIUBTE_NAME)) {
                this.getVdbHeader().setProducerVersion(value);
            } else if (name.equalsIgnoreCase(TIME_CHANGED_ATTRIUBTE_NAME)) {
                this.getVdbHeader().setTimeLastChanged(value);
            } else if (name.equalsIgnoreCase(TIME_PRODUCED_ATTRIUBTE_NAME)) {
                this.getVdbHeader().setTimeLastProduced(value);
            } else if (qname.equalsIgnoreCase(XMI_VERSION_0020_ATTRIBUTE_NAME)) {
                this.getVdbHeader().setXmiVersion(value);
            } else if (qname.equalsIgnoreCase(XMI_VERSION_0011_ATTRIBUTE_NAME)) {
                this.getVdbHeader().setXmiVersion(value);
            }
            ++i;
        }
    }

    private void processModelRefAttributes(Attributes atts) {
        VdbModelInfo info = new VdbModelInfo();
        int i = 0;
        while (i < atts.getLength()) {
            String qname = atts.getQName(i);
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (name.equalsIgnoreCase(UUID_ATTRIBUTE_NAME) && qname.equalsIgnoreCase(UUID_ATTRIBUTE_NAME)) {
                info.setUUID(value);
            } else if (name.equalsIgnoreCase(NAME_ATTRIBUTE_NAME)) {
                info.setName(value);
            } else if (name.equalsIgnoreCase(MODEL_PATH_ATTRIBUTE_NAME)) {
                info.setPath(value);
            } else if (name.equalsIgnoreCase(MODEL_LOC_ATTRIBUTE_NAME)) {
                info.setLocation(value);
            } else if (name.equalsIgnoreCase(MODEL_TYPE_ATTRIBUTE_NAME)) {
                info.setModelType(value);
            } else if (name.equalsIgnoreCase(PRIMARY_URI_ATTRIBUTE_NAME)) {
                info.setPrimaryMetamodelURI(value);
            } else if (name.equalsIgnoreCase(VISIBLE_ATTRIBUTE_NAME)) {
                info.setVisible(value);
            } else if (name.equalsIgnoreCase(CHECKSUM_ATTRIBUTE_NAME)) {
                info.setCheckSum(value);
            }
            ++i;
        }
        this.getVdbHeader().addModelInfo(info);
    }

    private void processNonModelRefAttributes(Attributes atts) {
        VdbNonModelInfo info = new VdbNonModelInfo();
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (name.equalsIgnoreCase(NAME_ATTRIBUTE_NAME)) {
                info.setName(value);
            } else if (name.equalsIgnoreCase(MODEL_PATH_ATTRIBUTE_NAME)) {
                info.setPath(value);
            } else if (name.equalsIgnoreCase(CHECKSUM_ATTRIBUTE_NAME)) {
                info.setCheckSum(value);
            }
            ++i;
        }
        this.getVdbHeader().addNonModelInfo(info);
    }

    private void processMarkerAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            Integer markerValue;
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (name.equalsIgnoreCase(SEVERITY_ATTRIBUTE_NAME) && (markerValue = (Integer)VdbHeader.severityNameToValueMap.get(value.toUpperCase())) != null && markerValue.compareTo(this.getVdbHeader().getSeverityValue()) > 0) {
                this.getVdbHeader().setSeverity(value.toUpperCase());
            }
            ++i;
        }
    }
}

