/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xmi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.designer.common.xmi.TerminatingXMIHeaderContentHandler;
import org.teiid.designer.common.xmi.XMIHeader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMIHeaderReader {
    private static final String XML_DECLARATION_PREFIX_STRING = "<?xml version=";

    public static XMIHeader readHeader(InputStream istream) throws TeiidDesignerException {
        XMIHeaderReader reader = new XMIHeaderReader();
        return reader.read(istream);
    }

    public static XMIHeader readHeader(File file) throws TeiidDesignerException {
        XMIHeaderReader reader = new XMIHeaderReader();
        return reader.read(file);
    }

    public XMIHeader read(InputStream istream) throws TeiidDesignerException {
        if (istream == null) {
            throw new IllegalArgumentException("XMIHeaderReader.The_InputStream_reference_may_not_be_null._1");
        }
        TerminatingXMIHeaderContentHandler handler = new TerminatingXMIHeaderContentHandler();
        try {
            Thread.currentThread().setContextClassLoader(XMIHeaderReader.class.getClassLoader());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(new InputSource(istream), (DefaultHandler)handler);
        }
        catch (SAXException e) {
            if (!"HeaderFoundException".equals(e.getMessage()) && !"XMINotFoundException".equals(e.getMessage())) {
                boolean cfr_ignored_0 = e instanceof SAXParseException;
            }
        }
        catch (IOException iOException) {
        }
        catch (Throwable e) {
            throw new TeiidDesignerException(e, "XMIHeaderReader.Error_in_parsing_file_1");
        }
        return handler.getXmiHeader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMIHeader read(File file) throws TeiidDesignerException {
        XMIHeader xMIHeader;
        FileInputStream fis;
        block17: {
            if (file == null) {
                throw new IllegalArgumentException("XMIHeaderReader.The_file_reference_may_not_be_null_2");
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("XMIHeaderReader.The_file_0_does_not_exist_and_therefore_cannot_be_read._3");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("XMIHeaderReader.The_file_0_does_not_have_read_privileges._4");
            }
            if (!XMIHeaderReader.isXmlFile(file)) {
                return null;
            }
            fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                xMIHeader = this.read(bis);
                if (bis == null) break block17;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new TeiidDesignerException((Throwable)e, "XMIHeaderReader.Error_in_parsing_file_1");
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        if (fis == null) return xMIHeader;
        try {
            fis.close();
            return xMIHeader;
        }
        catch (IOException iOException) {}
        return xMIHeader;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isXmlFile(File file) {
        FileInputStream fis;
        block12: {
            fis = null;
            fis = new FileInputStream(file);
            byte[] buf = new byte[32];
            fis.read(buf);
            if (!new String(buf).startsWith(XML_DECLARATION_PREFIX_STRING)) break block12;
            if (fis == null) return true;
            try {
                fis.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
            catch (IOException iOException) {
                try {
                    if (fis == null) return false;
                }
                catch (Throwable throwable) {
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    fis.close();
                    return false;
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        if (fis == null) return false;
        try {
            fis.close();
            return false;
        }
        catch (IOException iOException) {}
        return false;
    }
}

