/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.common.xml.SAXBuilderHelper;
import org.teiid.designer.common.xml.XMLVisitor;

public class JdomHelper {
    public static final String DEFAULT_INDENT = "  ";
    public static final boolean DEFAULT_VALIDATION = false;
    public static final int PRE_ORDER_TRAVERSAL = 0;
    public static final int POST_ORDER_TRAVERSAL = 1;
    public static final int LEVEL_ORDER_TRAVERSAL = 2;

    public static Document buildDocument(String filename) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), filename, false);
    }

    public static Document buildDocument(File file) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), file, false);
    }

    public static Document buildDocument(String filename, boolean validateXML) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), filename, validateXML);
    }

    public static Document buildDocument(String saxDriverClass, String filename, boolean validateXML) throws IOException, JDOMException {
        if (filename == null) {
            CoreArgCheck.isNotNull((Object)filename, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_file_name_may_not_be_null_3", new Object[0]));
        }
        if (filename.length() == 0) {
            CoreArgCheck.isNotZeroLength((String)filename, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_file_name_may_not_be_zero-length_4", new Object[0]));
        }
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(saxDriverClass, validateXML);
        return builder.build(new File(filename));
    }

    public static Document buildDocument(String saxDriverClass, File file, boolean validateXML) throws IOException, JDOMException {
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(saxDriverClass, validateXML);
        return builder.build(file);
    }

    public static Document buildDocument(InputStream stream) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), stream, false);
    }

    public static Document buildDocument(InputStream stream, boolean validateXML) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), stream, validateXML);
    }

    public static Document buildDocument(String saxDriverClass, InputStream stream, boolean validateXML) throws IOException, JDOMException {
        if (stream == null) {
            CoreArgCheck.isNotNull((Object)stream, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_InputStream_may_not_be_null_7", new Object[0]));
        }
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(saxDriverClass, validateXML);
        return builder.build(stream);
    }

    public static Document buildDocument(Reader stream) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), stream, false);
    }

    public static Document buildDocument(Reader stream, boolean validateXML) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), stream, validateXML);
    }

    public static Document buildDocument(String saxDriverClass, Reader stream, boolean validateXML) throws IOException, JDOMException {
        if (stream == null) {
            CoreArgCheck.isNotNull((Object)stream, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_InputStream_may_not_be_null_10", new Object[0]));
        }
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(saxDriverClass, validateXML);
        return builder.build(stream);
    }

    public static Document createNewDocument(String rootTag) {
        if (rootTag == null) {
            CoreArgCheck.isNotNull((Object)rootTag, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_root_tag_name_may_not_be_null_11", new Object[0]));
        }
        if (rootTag.length() == 0) {
            CoreArgCheck.isNotZeroLength((String)rootTag, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_root_tag_name_may_not_be_zero-length_12", new Object[0]));
        }
        Element root = new Element(rootTag);
        return new Document(root);
    }

    public static List getDescendents(int traversalMethod, Element parent, final Namespace ns) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_13", new Object[0]));
        }
        if (ns == null) {
            CoreArgCheck.isNotNull((Object)ns, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_Namespace_reference_may_not_be_null_14", new Object[0]));
        }
        final LinkedList results = new LinkedList();
        switch (traversalMethod) {
            case 0: {
                JdomHelper.preOrderTraversal(parent, new XMLVisitor(){

                    @Override
                    public void visit(Object obj) {
                        if (((Element)obj).getNamespace().equals((Object)ns)) {
                            results.add(obj);
                        }
                    }
                });
                break;
            }
            case 1: {
                JdomHelper.postOrderTraversal(parent, new XMLVisitor(){

                    @Override
                    public void visit(Object obj) {
                        if (((Element)obj).getNamespace().equals((Object)ns)) {
                            results.add(obj);
                        }
                    }
                });
                break;
            }
            case 2: {
                JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

                    @Override
                    public void visit(Object obj) {
                        if (((Element)obj).getNamespace().equals((Object)ns)) {
                            results.add(obj);
                        }
                    }
                });
            }
        }
        return results;
    }

    public static List getDescendents(Element parent) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_15", new Object[0]));
        }
        final LinkedList results = new LinkedList();
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                results.add(obj);
            }
        });
        return results;
    }

    public static List getDescendents(Element parent, final String name) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_16", new Object[0]));
        }
        if (name == null) {
            CoreArgCheck.isNotNull((Object)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_null_17", new Object[0]));
        }
        if (name.length() == 0) {
            CoreArgCheck.isNotZeroLength((String)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_18", new Object[0]));
        }
        final LinkedList results = new LinkedList();
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                if (((Element)obj).getName().equals(name)) {
                    results.add(obj);
                }
            }
        });
        return results;
    }

    public static List getDescendents(Element parent, final Namespace ns) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_19", new Object[0]));
        }
        if (ns == null) {
            CoreArgCheck.isNotNull((Object)ns, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_Namespace_may_not_be_null_20", new Object[0]));
        }
        final LinkedList results = new LinkedList();
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                if (((Element)obj).getNamespace().equals((Object)ns)) {
                    results.add(obj);
                }
            }
        });
        return results;
    }

    public static List getDescendents(Element parent, final String name, final Namespace ns) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_21", new Object[0]));
        }
        if (name == null) {
            CoreArgCheck.isNotNull((Object)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_null_22", new Object[0]));
        }
        if (name.length() == 0) {
            CoreArgCheck.isNotZeroLength((String)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_23", new Object[0]));
        }
        final LinkedList results = new LinkedList();
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                if (((Element)obj).getName().equals(name) && ((Element)obj).getNamespace().equals((Object)ns)) {
                    results.add(obj);
                }
            }
        });
        return results;
    }

    public static int getDescendentCount(Element parent) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_24", new Object[0]));
        }
        XMLVisitor visitor = new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                ++this.count;
            }
        };
        JdomHelper.levelOrderTraversal(parent, visitor);
        return visitor.count;
    }

    public static int getDescendentCount(Element parent, final Namespace ns) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_25", new Object[0]));
        }
        XMLVisitor visitor = new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                if (((Element)obj).getNamespace().equals((Object)ns)) {
                    ++this.count;
                }
            }
        };
        JdomHelper.levelOrderTraversal(parent, visitor);
        return visitor.count;
    }

    public static int getDescendentCount(Element parent, final String name) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_26", new Object[0]));
        }
        if (name == null) {
            CoreArgCheck.isNotNull((Object)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_null_27", new Object[0]));
        }
        if (name.length() == 0) {
            CoreArgCheck.isNotZeroLength((String)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_28", new Object[0]));
        }
        XMLVisitor visitor = new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                if (((Element)obj).getName().equals(name)) {
                    ++this.count;
                }
            }
        };
        JdomHelper.levelOrderTraversal(parent, visitor);
        return visitor.count;
    }

    public static Element findElement(Element parent, final String name) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_29", new Object[0]));
        }
        if (name == null) {
            CoreArgCheck.isNotNull((Object)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_null_30", new Object[0]));
        }
        if (name.length() == 0) {
            CoreArgCheck.isNotZeroLength((String)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_31", new Object[0]));
        }
        XMLVisitor visitor = new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                if (this.result != null) {
                    return;
                }
                if (((Element)obj).getName().equals(name)) {
                    this.result = (Element)obj;
                }
            }
        };
        JdomHelper.levelOrderTraversal(parent, visitor);
        return visitor.result;
    }

    public static Element findElement(Element parent, final String name, final Namespace ns) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_32", new Object[0]));
        }
        if (name == null) {
            CoreArgCheck.isNotNull((Object)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_null_33", new Object[0]));
        }
        if (name.length() == 0) {
            CoreArgCheck.isNotZeroLength((String)name, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_34", new Object[0]));
        }
        if (ns == null) {
            CoreArgCheck.isNotNull((Object)ns, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_Namespace_reference_may_not_be_null_35", new Object[0]));
        }
        XMLVisitor visitor = new XMLVisitor(){

            @Override
            public void visit(Object obj) {
                if (this.result != null) {
                    return;
                }
                if (((Element)obj).getName().equals(name) && ((Element)obj).getNamespace().equals((Object)ns)) {
                    this.result = (Element)obj;
                }
            }
        };
        JdomHelper.levelOrderTraversal(parent, visitor);
        return visitor.result;
    }

    public static void levelOrderTraversal(Element parent, XMLVisitor v) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_36", new Object[0]));
        }
        if (v == null) {
            CoreArgCheck.isNotNull((Object)v, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_XMLVisitor_reference_may_not_be_null_37", new Object[0]));
        }
        LinkedList queue = new LinkedList(parent.getChildren());
        while (queue.size() != 0) {
            Element child = (Element)queue.getFirst();
            v.visit(child);
            queue.addAll(child.getChildren());
            queue.removeFirst();
        }
    }

    public static void preOrderTraversal(Element parent, XMLVisitor v) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_38", new Object[0]));
        }
        if (v == null) {
            CoreArgCheck.isNotNull((Object)v, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_XMLVisitor_reference_may_not_be_null_39", new Object[0]));
        }
        List children = parent.getChildren();
        int i = 0;
        int len = children.size();
        while (i < len) {
            Element child = (Element)children.get(i);
            v.visit(child);
            JdomHelper.preOrderTraversal(child, v);
            ++i;
        }
    }

    public static void postOrderTraversal(Element parent, XMLVisitor v) {
        if (parent == null) {
            CoreArgCheck.isNotNull((Object)parent, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_40", new Object[0]));
        }
        if (v == null) {
            CoreArgCheck.isNotNull((Object)v, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_XMLVisitor_reference_may_not_be_null_41", new Object[0]));
        }
        List children = parent.getChildren();
        int i = 0;
        int len = children.size();
        while (i < len) {
            Element child = (Element)children.get(i);
            JdomHelper.postOrderTraversal(child, v);
            v.visit(child);
            ++i;
        }
    }

    public static void write(Document doc, String filename) throws IOException {
        JdomHelper.write(doc, filename, DEFAULT_INDENT, true);
    }

    public static void write(Document doc, String filename, String indent, boolean newlines) throws IOException {
        CoreArgCheck.isNotNull((Object)doc, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_Document_reference_may_not_be_null_42", new Object[0]));
        CoreArgCheck.isNotNull((Object)filename, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_filename_may_not_be_null_43", new Object[0]));
        if (filename.length() == 0) {
            CoreArgCheck.isNotZeroLength((String)filename, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_filename_may_not_be_zero-length_44", new Object[0]));
        }
        try (FileOutputStream out = new FileOutputStream(filename);){
            JdomHelper.write(doc, out, indent, newlines);
            out.flush();
        }
    }

    public static void write(Document doc, OutputStream stream) throws IOException {
        JdomHelper.write(doc, stream, DEFAULT_INDENT, true);
    }

    public static void write(Document doc, OutputStream stream, String indent, boolean newlines) throws IOException {
        if (doc == null) {
            CoreArgCheck.isNotNull((Object)doc, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_Document_reference_may_not_be_null_45", new Object[0]));
        }
        if (stream == null) {
            CoreArgCheck.isNotNull((Object)stream, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_OutputStream_reference_may_not_be_null_46", new Object[0]));
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indent, newlines));
        outputter.output(doc, stream);
    }

    public static void write(Document doc, Writer writer) throws IOException {
        JdomHelper.write(doc, writer, DEFAULT_INDENT, true);
    }

    public static void write(Document doc, Writer writer, String indent, boolean newlines) throws IOException {
        if (doc == null) {
            CoreArgCheck.isNotNull((Object)doc, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_Document_reference_may_not_be_null_47", new Object[0]));
        }
        if (writer == null) {
            CoreArgCheck.isNotNull((Object)writer, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_Writer_reference_may_not_be_null_48", new Object[0]));
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indent, newlines));
        outputter.output(doc, writer);
    }

    public static String write(Document doc) throws IOException {
        return JdomHelper.write(doc, DEFAULT_INDENT, true);
    }

    public static String write(Document doc, String indent, boolean newlines) throws IOException {
        if (doc == null) {
            CoreArgCheck.isNotNull((Object)doc, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_Document_reference_may_not_be_null_49", new Object[0]));
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indent, newlines));
        StringWriter writer = new StringWriter();
        outputter.output(doc, (Writer)writer);
        return writer.getBuffer().toString();
    }

    public static void print(PrintStream stream, Document doc) {
        if (stream == null) {
            CoreArgCheck.isNotNull((Object)stream, (String)CoreModelerPlugin.Util.getString("JdomHelper.The_stream_reference_may_not_be_null_50", new Object[0]));
        }
        stream.println(CoreModelerPlugin.Util.getString("JdomHelper.JDOM_Document_tree_51", new Object[0]));
        Element root = doc.getRootElement();
        JdomHelper.print(root, stream, CoreModelerPlugin.Util.getString("JdomHelper.___52", new Object[0]));
    }

    private static void print(Element elm, PrintStream stream, String leadingString) {
        stream.println(String.valueOf(leadingString) + elm.getName());
        Iterator itr = elm.getChildren().iterator();
        while (itr.hasNext()) {
            JdomHelper.print((Element)itr.next(), stream, String.valueOf(leadingString) + CoreModelerPlugin.Util.getString("JdomHelper.___53", new Object[0]));
        }
    }

    public static String getContentValue(Object jdomObject) {
        if (jdomObject == null) {
            return null;
        }
        if (jdomObject instanceof String) {
            return (String)jdomObject;
        }
        if (jdomObject instanceof Element) {
            return ((Element)jdomObject).getText();
        }
        if (jdomObject instanceof Attribute) {
            return ((Attribute)jdomObject).getValue();
        }
        if (jdomObject instanceof Text) {
            return ((Text)jdomObject).getValue();
        }
        if (jdomObject instanceof Namespace) {
            return ((Namespace)jdomObject).getURI();
        }
        if (jdomObject instanceof Comment) {
            return ((Comment)jdomObject).getText();
        }
        if (jdomObject instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)jdomObject).getData();
        }
        return jdomObject.toString();
    }

    public static Format getFormat(String indent, boolean newlines) {
        Format format = Format.getPrettyFormat();
        format.setIndent(indent);
        if (newlines) {
            format.setLineSeparator("\n");
        } else {
            format.setLineSeparator("");
        }
        return format;
    }
}

