/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xml;

import org.jdom.Verifier;
import org.teiid.core.designer.util.CoreStringUtil;

public class XmlUtil {
    private XmlUtil() {
    }

    public static String containsValidCharacters(String str) {
        return Verifier.checkCharacterData((String)str);
    }

    public static String removeInvalidCharacters(String str) {
        if (str != null) {
            char[] orig = str.toCharArray();
            int origLength = orig.length;
            StringBuffer sb = new StringBuffer(str.length());
            int i = 0;
            while (i != origLength) {
                char c = orig[i];
                if (Verifier.isXMLCharacter((int)c)) {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return str;
    }

    public static String escapeCharacterData(String text) {
        if (text == null) {
            return null;
        }
        String escaped = CoreStringUtil.replace((String)text, (String)"&", (String)"&amp;");
        escaped = CoreStringUtil.replace((String)escaped, (String)">", (String)"&gt;");
        escaped = CoreStringUtil.replace((String)escaped, (String)"<", (String)"&lt;");
        escaped = CoreStringUtil.replace((String)escaped, (String)"\"", (String)"&quot;");
        escaped = CoreStringUtil.replace((String)escaped, (String)"'", (String)"&apos;");
        return escaped;
    }
}

