/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xsd;

import java.util.ArrayList;
import java.util.List;

public final class XsdHeader {
    private List<String> namespaceURIs = new ArrayList<String>();
    private List<String> importNamespaceURIs = new ArrayList<String>();
    private List<String> importSchemaLocations = new ArrayList<String>();
    private List<String> includeSchemaLocations = new ArrayList<String>();
    private String targetNamespaceURI;

    public String getTargetNamespaceURI() {
        return this.targetNamespaceURI;
    }

    public String[] getNamespaceURIs() {
        return this.namespaceURIs.toArray(new String[this.namespaceURIs.size()]);
    }

    public String[] getImportNamespaces() {
        return this.importNamespaceURIs.toArray(new String[this.importNamespaceURIs.size()]);
    }

    public String[] getImportSchemaLocations() {
        return this.importSchemaLocations.toArray(new String[this.importSchemaLocations.size()]);
    }

    public String[] getIncludeSchemaLocations() {
        return this.includeSchemaLocations.toArray(new String[this.includeSchemaLocations.size()]);
    }

    public void addNamespaceURI(String uri) {
        if (!this.namespaceURIs.contains(uri)) {
            this.namespaceURIs.add(uri);
        }
    }

    public void addImportNamespaceURI(String uri) {
        if (!this.importNamespaceURIs.contains(uri)) {
            this.importNamespaceURIs.add(uri);
        }
    }

    public void addImportSchemaLocation(String location) {
        if (!this.importSchemaLocations.contains(location)) {
            this.importSchemaLocations.add(location);
        }
    }

    public void addIncludeSchemaLocation(String location) {
        if (!this.includeSchemaLocations.contains(location)) {
            this.includeSchemaLocations.add(location);
        }
    }

    public void setTargetNamespaceURI(String uri) {
        this.targetNamespaceURI = uri;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Xsd Header:");
        sb.append("\n  targetNamespace:       ");
        sb.append(this.getTargetNamespaceURI());
        sb.append("\n  Namespace URIs:");
        String[] nsUris = this.getNamespaceURIs();
        int i = 0;
        while (i < nsUris.length) {
            sb.append("\n    ");
            sb.append(nsUris[i]);
            ++i;
        }
        sb.append("\n  Import Namespace URIs:");
        String[] imports = this.getImportNamespaces();
        int i2 = 0;
        while (i2 < imports.length) {
            sb.append("\n    ");
            sb.append(imports[i2]);
            ++i2;
        }
        sb.append("\n  Import Schema Locations:");
        String[] importLocs = this.getImportSchemaLocations();
        int i3 = 0;
        while (i3 < importLocs.length) {
            sb.append("\n    ");
            sb.append(importLocs[i3]);
            ++i3;
        }
        sb.append("\n  Include Schema Locations:");
        String[] includeLocs = this.getIncludeSchemaLocations();
        int i4 = 0;
        while (i4 < includeLocs.length) {
            sb.append("\n    ");
            sb.append(includeLocs[i4]);
            ++i4;
        }
        return sb.toString();
    }
}

