/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.UTFDataFormatException;

public class CodeByteStream {
    protected byte[] bytes;
    protected int byteOffset = 0;
    protected int bitOffset = 0;
    protected int markByteOffset = -1;
    protected int markBitOffset = -1;

    public CodeByteStream() {
        this(16);
    }

    public CodeByteStream(byte[] bytes) {
        this.bytes = bytes;
    }

    public CodeByteStream(int initialByteLength) {
        this.bytes = new byte[initialByteLength];
    }

    public int byteLength() {
        return (this.bitOffset + 7) / 8 + this.byteOffset;
    }

    public byte[] getBytes(int startOffset, int endOffset) {
        int byteLength = this.byteLength();
        if (startOffset > byteLength || endOffset > byteLength || startOffset > endOffset) {
            throw new IndexOutOfBoundsException();
        }
        int length = endOffset - startOffset;
        byte[] result = new byte[length];
        System.arraycopy(this.bytes, startOffset, result, 0, length);
        if (endOffset == byteLength && this.bitOffset != 0) {
            int mask = (1 << this.bitOffset) - 1;
            int n = length - 1;
            result[n] = (byte)(result[n] & mask << 8 - this.bitOffset);
        }
        return result;
    }

    protected void grow() {
        byte[] newBytes = new byte[this.bytes.length * 2 + 1];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
        this.bytes = newBytes;
    }

    public void mark() {
        this.markByteOffset = this.byteOffset;
        this.markBitOffset = this.bitOffset;
    }

    public int readBit() {
        int value = this.bytes[this.byteOffset] >> 7 - this.bitOffset & 1;
        if (++this.bitOffset >= 8) {
            this.bitOffset = 0;
            ++this.byteOffset;
        }
        return value;
    }

    public int readBits(int numBits) {
        int value = 0;
        while (numBits > 0) {
            int bitsToRead = 8 - this.bitOffset;
            if (bitsToRead > numBits) {
                bitsToRead = numBits;
            }
            int mask = (1 << bitsToRead) - 1;
            value |= (this.bytes[this.byteOffset] >> 8 - this.bitOffset - bitsToRead & mask) << numBits - bitsToRead;
            numBits -= bitsToRead;
            this.bitOffset += bitsToRead;
            if (this.bitOffset < 8) continue;
            this.bitOffset -= 8;
            ++this.byteOffset;
        }
        return value;
    }

    public final int readByte() {
        if (this.bitOffset == 0) {
            return this.bytes[this.byteOffset++] & 0xFF;
        }
        int value = 0;
        int numBits = 8;
        while (numBits > 0) {
            int bitsToRead = 8 - this.bitOffset;
            if (bitsToRead > numBits) {
                bitsToRead = numBits;
            }
            int mask = (1 << bitsToRead) - 1;
            value |= (this.bytes[this.byteOffset] >> 8 - this.bitOffset - bitsToRead & mask) << numBits - bitsToRead;
            numBits -= bitsToRead;
            this.bitOffset += bitsToRead;
            if (this.bitOffset < 8) continue;
            this.bitOffset -= 8;
            ++this.byteOffset;
        }
        return value;
    }

    public int readGamma() {
        int numBits = this.readUnary();
        return this.readBits(numBits - 1) | 1 << numBits - 1;
    }

    public char[] readUTF() throws UTFDataFormatException {
        int utflen = this.readByte();
        if (utflen == 255) {
            int high = this.readByte();
            int low = this.readByte();
            utflen = (high << 8) + low;
        }
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = this.readByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = this.readByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = this.readByte();
                    int char3 = this.readByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        if (strlen < utflen) {
            char[] cArray = str;
            str = new char[strlen];
            System.arraycopy(cArray, 0, str, 0, strlen);
        }
        return str;
    }

    public int readUnary() {
        int value = 1;
        int mask = 1 << 7 - this.bitOffset;
        while ((this.bytes[this.byteOffset] & mask) != 0) {
            ++value;
            if (++this.bitOffset >= 8) {
                this.bitOffset = 0;
                ++this.byteOffset;
                mask = 128;
                continue;
            }
            mask >>>= 1;
        }
        if (++this.bitOffset >= 8) {
            this.bitOffset = 0;
            ++this.byteOffset;
        }
        return value;
    }

    public void reset() {
        this.bitOffset = 0;
        this.byteOffset = 0;
        this.markBitOffset = -1;
        this.markByteOffset = -1;
    }

    public void reset(byte[] bytes) {
        this.bytes = bytes;
        this.reset();
    }

    public void reset(byte[] bytes, int byteOffset) {
        this.reset(bytes);
        this.byteOffset = byteOffset;
    }

    public boolean resetToMark() {
        if (this.markByteOffset == -1) {
            return false;
        }
        this.byteOffset = this.markByteOffset;
        this.bitOffset = this.markBitOffset;
        this.markBitOffset = -1;
        this.markByteOffset = -1;
        return true;
    }

    public void skipBits(int numBits) {
        int newOffset = this.byteOffset * 8 + this.bitOffset + numBits;
        if (newOffset < 0 || (newOffset + 7) / 8 >= this.bytes.length) {
            throw new IllegalArgumentException();
        }
        this.byteOffset = newOffset / 8;
        this.bitOffset = newOffset % 8;
    }

    public byte[] toByteArray() {
        return this.getBytes(0, this.byteLength());
    }

    public void writeBit(int value) {
        int n = this.byteOffset++;
        this.bytes[n] = (byte)(this.bytes[n] | (value & 1) << 7 - this.bitOffset);
        if (++this.bitOffset >= 8) {
            this.bitOffset = 0;
            if (this.byteOffset >= this.bytes.length) {
                this.grow();
            }
        }
    }

    public void writeBits(int value, int numBits) {
        while (numBits > 0) {
            int bitsToWrite = 8 - this.bitOffset;
            if (bitsToWrite > numBits) {
                bitsToWrite = numBits;
            }
            int shift = 8 - this.bitOffset - bitsToWrite;
            int mask = (1 << bitsToWrite) - 1 << shift;
            this.bytes[this.byteOffset] = (byte)(this.bytes[this.byteOffset] & ~mask | value >>> numBits - bitsToWrite << shift & mask);
            numBits -= bitsToWrite;
            this.bitOffset += bitsToWrite;
            if (this.bitOffset < 8) continue;
            this.bitOffset -= 8;
            if (++this.byteOffset < this.bytes.length) continue;
            this.grow();
        }
    }

    public void writeByte(int value) {
        this.writeBits(value, 8);
    }

    public void writeGamma(int value) {
        if (value < 1) {
            throw new IllegalArgumentException();
        }
        int temp = value;
        int numBits = 0;
        while (temp != 0) {
            temp >>>= 1;
            ++numBits;
        }
        this.writeUnary(numBits);
        this.writeBits(value, numBits - 1);
    }

    public void writeUTF(char[] str, int start, int end) {
        char c;
        int utflen = 0;
        int i = start;
        while (i < end) {
            c = str[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen < 255) {
            this.writeByte(utflen & 0xFF);
        } else {
            if (utflen > 65535) {
                throw new IllegalArgumentException();
            }
            this.writeByte(255);
            this.writeByte(utflen >>> 8 & 0xFF);
            this.writeByte(utflen >>> 0 & 0xFF);
        }
        i = start;
        while (i < end) {
            c = str[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte(c);
            } else if (c > '\u07ff') {
                this.writeByte(0xE0 | c >> 12 & 0xF);
                this.writeByte(0x80 | c >> 6 & 0x3F);
                this.writeByte(0x80 | c >> 0 & 0x3F);
            } else {
                this.writeByte(0xC0 | c >> 6 & 0x1F);
                this.writeByte(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    public void writeUnary(int value) {
        if (value < 1) {
            throw new IllegalArgumentException();
        }
        int mask = 1 << 7 - this.bitOffset;
        while (--value > 0) {
            int n = this.byteOffset++;
            this.bytes[n] = (byte)(this.bytes[n] | mask);
            if (++this.bitOffset >= 8) {
                this.bitOffset = 0;
                if (this.byteOffset >= this.bytes.length) {
                    this.grow();
                }
                mask = 128;
                continue;
            }
            mask >>>= 1;
        }
        int n = this.byteOffset++;
        this.bytes[n] = (byte)(this.bytes[n] & ~mask);
        if (++this.bitOffset >= 8) {
            this.bitOffset = 0;
            if (this.byteOffset >= this.bytes.length) {
                this.grow();
            }
        }
    }
}

