/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.UTFDataFormatException;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.index.CodeByteStream;
import org.teiid.designer.core.index.IndexBlock;
import org.teiid.designer.core.index.WordEntry;

public class GammaCompressedIndexBlock
extends IndexBlock {
    CodeByteStream writeCodeStream = new CodeByteStream();
    CodeByteStream readCodeStream = new CodeByteStream(this.field.buffer());
    char[] prevWord = null;

    public GammaCompressedIndexBlock(int blockSize) {
        super(blockSize);
    }

    @Override
    public boolean addEntry(WordEntry entry) {
        this.writeCodeStream.reset();
        this.encodeEntry(entry, this.prevWord, this.writeCodeStream);
        if (this.getOffset() + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] bytes = this.writeCodeStream.toByteArray();
        this.field.put(this.getOffset(), bytes);
        this.setOffset(this.getOffset() + bytes.length);
        this.prevWord = entry.getWord();
        return true;
    }

    protected void encodeEntry(WordEntry entry, char[] prevWord, CodeByteStream codeStream) {
        char[] word = entry.getWord();
        int prefixLen = prevWord == null ? 0 : Math.min(StringUtilities.prefixLength((char[])prevWord, (char[])word), 255);
        codeStream.writeByte(prefixLen);
        codeStream.writeUTF(word, prefixLen, word.length);
        int n = entry.getNumRefs();
        codeStream.writeGamma(n);
        int prevRef = 0;
        int i = 0;
        while (i < n) {
            int ref = entry.getRef(i);
            if (ref <= prevRef) {
                throw new IllegalArgumentException();
            }
            codeStream.writeGamma(ref - prevRef);
            prevRef = ref;
            ++i;
        }
    }

    @Override
    public void flush() {
        if (this.getOffset() > 0) {
            this.field.putInt2(this.getOffset(), 0);
            this.setOffset(0);
            this.prevWord = null;
        }
    }

    @Override
    public boolean nextEntry(WordEntry entry) {
        char[] word;
        block6: {
            this.readCodeStream.reset(this.field.buffer(), this.getOffset());
            int prefixLength = this.readCodeStream.readByte();
            word = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + word.length];
                System.arraycopy(this.prevWord, 0, temp, 0, Math.min(prefixLength, this.prevWord.length));
                System.arraycopy(word, 0, temp, Math.min(prefixLength, this.prevWord.length), word.length);
                word = temp;
            }
            if (word.length != 0) break block6;
            return false;
        }
        try {
            entry.reset(word);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            int i = 0;
            while (i < n) {
                int ref = prevRef + this.readCodeStream.readGamma();
                if (ref < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref);
                prevRef = ref;
                ++i;
            }
            this.setOffset(this.readCodeStream.byteLength());
            this.prevWord = word;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.prevWord = null;
    }
}

