/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.designer.core.index.BlocksIndexOutput;
import org.teiid.designer.core.index.IDocument;
import org.teiid.designer.core.index.IndexOutput;
import org.teiid.designer.core.index.IndexedFile;
import org.teiid.designer.core.index.IndexedFileHashedArray;
import org.teiid.designer.core.index.WordEntry;

public class InMemoryIndex {
    protected List<WordEntry> words;
    protected IndexedFileHashedArray files;
    protected long footprint;
    private WordEntry[] sortedWordEntries;
    private IndexedFile[] sortedFiles;

    public InMemoryIndex() {
        this.init();
    }

    public IndexedFile addDocument(IDocument document) {
        IndexedFile indexedFile = this.files.add(document);
        this.footprint += (long)(indexedFile.footprint() + 4);
        this.sortedFiles = null;
        return indexedFile;
    }

    protected void addRef(char[] word, int fileNum) {
        WordEntry entry = new WordEntry(word);
        entry.addRef(fileNum);
        this.words.add(entry);
        this.sortedWordEntries = null;
        this.footprint += (long)entry.footprint();
    }

    public void addRef(IndexedFile indexedFile, char[] word) {
        this.addRef(word, indexedFile.getFileNumber());
    }

    public long getFootprint() {
        return this.footprint;
    }

    public IndexedFile getIndexedFile(String path) {
        return this.files.get(path);
    }

    public int getNumFiles() {
        return this.files.size();
    }

    public int getNumWords() {
        return this.words.size();
    }

    protected IndexedFile[] getSortedFiles() {
        if (this.sortedFiles == null) {
            Object[] indexedFiles = this.files.asArray();
            Arrays.sort(indexedFiles);
            this.sortedFiles = indexedFiles;
        }
        return this.sortedFiles;
    }

    protected WordEntry[] getSortedWordEntries() {
        if (this.sortedWordEntries == null) {
            Object[] words = this.words.toArray(new WordEntry[this.words.size()]);
            Arrays.sort(words);
            this.sortedWordEntries = words;
        }
        return this.sortedWordEntries;
    }

    public void init() {
        this.words = new ArrayList<WordEntry>(256);
        this.files = new IndexedFileHashedArray(101);
        this.footprint = 0L;
        this.sortedWordEntries = null;
        this.sortedFiles = null;
    }

    public void save(File file) throws IOException {
        BlocksIndexOutput output = new BlocksIndexOutput(file);
        this.save(output);
    }

    protected void save(IndexOutput output) throws IOException {
        boolean ok = false;
        try {
            output.open();
            IndexedFile[] indexedFiles = this.files.asArray();
            int i = 0;
            int length = indexedFiles.length;
            while (i < length) {
                output.addFile(indexedFiles[i]);
                ++i;
            }
            this.getSortedWordEntries();
            i = 0;
            int numWords = this.sortedWordEntries.length;
            while (i < numWords) {
                output.addWord(this.sortedWordEntries[i]);
                ++i;
            }
            output.flush();
            output.close();
            ok = true;
        }
        finally {
            if (!ok && output != null) {
                output.close();
            }
        }
    }
}

