/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.util.Arrays;
import org.teiid.core.designer.util.CharOperation;
import org.teiid.designer.core.index.Block;
import org.teiid.designer.core.index.WordEntry;

public abstract class IndexBlock
extends Block {
    private int offset = 0;

    public IndexBlock(int blockSize) {
        super(blockSize);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isEmpty() {
        return this.getOffset() == 0;
    }

    public abstract boolean addEntry(WordEntry var1);

    @Override
    public void clear() {
        this.reset();
        super.clear();
    }

    public WordEntry findEntryPrefixedBy(char[] word, boolean isCaseSensitive) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!CharOperation.prefixEquals((char[])entry.getWord(), (char[])word, (boolean)isCaseSensitive)) continue;
            return entry;
        }
        return null;
    }

    public WordEntry findExactEntry(char[] word) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!Arrays.equals(entry.getWord(), word)) continue;
            return entry;
        }
        return null;
    }

    public abstract boolean nextEntry(WordEntry var1);

    public void reset() {
        this.setOffset(0);
    }
}

