/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.UTFDataFormatException;
import java.util.Arrays;
import org.teiid.designer.core.index.IndexBlock;
import org.teiid.designer.core.index.WordEntry;

public class SimpleIndexBlock
extends IndexBlock {
    public SimpleIndexBlock(int blockSize) {
        super(blockSize);
    }

    @Override
    public boolean addEntry(WordEntry entry) {
        char[] word = entry.getWord();
        int n = entry.getNumRefs();
        int sizeEstimate = 2 + word.length * 3 + 4 + n * 4;
        int offset = this.getOffset();
        if (offset + sizeEstimate > this.blockSize - 2) {
            return false;
        }
        offset += this.field.putUTF(offset, word);
        this.field.putInt4(offset, n);
        offset += 4;
        int i = 0;
        while (i < n) {
            this.field.putInt4(offset, entry.getRef(i));
            offset += 4;
            ++i;
        }
        this.setOffset(offset);
        return true;
    }

    public WordEntry findEntry(char[] word) {
        try {
            int byteLen;
            int offset = 0;
            while ((byteLen = this.field.getUInt2(offset)) != 0) {
                char[] tempWord = this.field.getUTF(offset);
                offset += byteLen + 2;
                if (Arrays.equals(tempWord, word)) {
                    WordEntry entry = new WordEntry(word);
                    int n = this.field.getInt4(offset);
                    offset += 4;
                    int i = 0;
                    while (i < n) {
                        int ref = this.field.getInt4(offset);
                        offset += 4;
                        entry.addRef(ref);
                        ++i;
                    }
                    return entry;
                }
                int n = this.field.getInt4(offset);
                offset += 4 + 4 * n;
            }
            return null;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return null;
        }
    }

    @Override
    public void flush() {
        if (this.getOffset() > 0) {
            this.field.putInt2(this.getOffset(), 0);
            this.setOffset(0);
        }
    }

    @Override
    public boolean nextEntry(WordEntry entry) {
        int byteLen;
        int offset;
        block4: {
            offset = this.getOffset();
            byteLen = this.field.getUInt2(offset);
            if (byteLen != 0) break block4;
            return false;
        }
        try {
            char[] word = this.field.getUTF(offset);
            entry.reset(word);
            int n = this.field.getInt4(offset += byteLen + 2);
            offset += 4;
            int i = 0;
            while (i < n) {
                int ref = this.field.getInt4(offset);
                offset += 4;
                entry.addRef(ref);
                ++i;
            }
            this.setOffset(offset);
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }
}

