/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.util.ArrayList;
import org.teiid.designer.core.index.IDocument;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IQueryResult;
import org.teiid.designer.core.index.InMemoryIndex;
import org.teiid.designer.core.index.IndexInput;
import org.teiid.designer.core.index.IndexedFile;
import org.teiid.designer.core.index.WordEntry;

public class SimpleIndexInput
extends IndexInput {
    protected WordEntry[] sortedWordEntries;
    protected IndexedFile currentFile;
    protected IndexedFile[] sortedFiles;
    protected InMemoryIndex index;

    public SimpleIndexInput(InMemoryIndex index) {
        this.index = index;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void close() {
        this.sortedFiles = null;
    }

    @Override
    public IndexedFile getCurrentFile() {
        if (!this.hasMoreFiles()) {
            return null;
        }
        return this.currentFile;
    }

    @Override
    public IndexedFile getIndexedFile(int fileNum) {
        int i = 0;
        while (i < this.sortedFiles.length) {
            if (this.sortedFiles[i].getFileNumber() == fileNum) {
                return this.sortedFiles[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public IndexedFile getIndexedFile(IDocument document) {
        String name = document.getName();
        int i = this.index.getNumFiles();
        while (i >= 1) {
            IndexedFile file = this.getIndexedFile(i);
            if (name.equals(file.getPath())) {
                return file;
            }
            --i;
        }
        return null;
    }

    @Override
    public int getNumFiles() {
        return this.index.getNumFiles();
    }

    @Override
    public int getNumWords() {
        return this.sortedWordEntries.length;
    }

    @Override
    public Object getSource() {
        return this.index;
    }

    public void init() {
        this.index.init();
    }

    @Override
    public void moveToNextFile() {
        ++this.filePosition;
        if (!this.hasMoreFiles()) {
            return;
        }
        this.currentFile = this.sortedFiles[this.filePosition - 1];
    }

    @Override
    public void moveToNextWordEntry() {
        ++this.wordPosition;
        if (this.hasMoreWords()) {
            this.currentWordEntry = this.sortedWordEntries[this.wordPosition - 1];
        }
    }

    @Override
    public void open() {
        this.sortedWordEntries = this.index.getSortedWordEntries();
        this.sortedFiles = this.index.getSortedFiles();
        this.filePosition = 1;
        this.wordPosition = 1;
        this.setFirstFile();
        this.setFirstWord();
    }

    @Override
    public IEntryResult[] queryEntriesPrefixedBy(char[] prefix) {
        return null;
    }

    @Override
    public IQueryResult[] queryFilesReferringToPrefix(char[] prefix) {
        return null;
    }

    @Override
    public IQueryResult[] queryInDocumentNames(String word) {
        this.setFirstFile();
        ArrayList<String> matches = new ArrayList<String>();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            if (file.getPath().indexOf(word) != -1) {
                matches.add(file.getPath());
            }
            this.moveToNextFile();
        }
        IQueryResult[] match = new IQueryResult[matches.size()];
        matches.toArray(match);
        return match;
    }

    @Override
    protected void setFirstFile() {
        this.filePosition = 1;
        if (this.sortedFiles.length > 0) {
            this.currentFile = this.sortedFiles[0];
        }
    }

    @Override
    protected void setFirstWord() {
        this.wordPosition = 1;
        if (this.sortedWordEntries.length > 0) {
            this.currentWordEntry = this.sortedWordEntries[0];
        }
    }
}

