/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metadata.runtime.impl;

import java.util.HashMap;
import java.util.Map;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.id.UUID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.EquivalenceUtil;
import org.teiid.designer.core.container.EObjectFinder;
import org.teiid.designer.core.types.DatatypeConstants;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metadata.runtime.impl.MetadataRecordDelegate;

public abstract class AbstractMetadataRecord
implements MetadataRecord {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INDEX_VERSION = 0;
    private String pathString;
    private String modelName;
    private String resourcePath;
    private int indexVersion = 0;
    private char recordType;
    private transient Map propValues;
    protected Object eObject;
    protected MetadataRecordDelegate delegate;
    private EObjectFinder finder;

    @Override
    public String getUUID() {
        return this.delegate.getUUID();
    }

    @Override
    public String getParentUUID() {
        return this.delegate.getParentUUID();
    }

    @Override
    public String getNameInSource() {
        return this.delegate.getNameInSource();
    }

    @Override
    public String getModelName() {
        if (this.modelName == null) {
            int prntIdx;
            int n = prntIdx = this.getFullName() != null ? this.getFullName().indexOf(46) : -1;
            this.modelName = prntIdx <= 0 ? this.getFullName() : (this.getFullName() != null ? this.getFullName().substring(0, prntIdx) : null);
        }
        return this.modelName;
    }

    @Override
    public String getFullName() {
        return this.delegate.getFullName();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getPathString() {
        if (this.pathString == null) {
            this.pathString = this.getFullName() != null ? this.getFullName().replace('.', '/') : null;
        }
        return this.pathString;
    }

    @Override
    public String getPath() {
        return this.getPathString();
    }

    @Override
    @Deprecated
    public String getParentFullName() {
        int prntIdx;
        int n = prntIdx = this.getFullName() != null ? this.getFullName().lastIndexOf(String.valueOf('.') + this.getName()) : -1;
        if (prntIdx <= 0) {
            return "";
        }
        return this.getFullName().substring(0, prntIdx);
    }

    @Override
    @Deprecated
    public String getParentPathString() {
        String parentFullName = this.getParentFullName();
        return parentFullName != null ? parentFullName.replace('.', '/') : null;
    }

    @Override
    public char getRecordType() {
        return this.recordType;
    }

    public void setNameInSource(String string) {
        this.delegate.setNameInSource(string);
    }

    public void setFullName(String fullName) {
        this.delegate.setFullName(fullName);
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setUUID(String string) {
        this.delegate.setUUID(string);
    }

    public void setParentUUID(String string) {
        this.delegate.setParentUUID(string);
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public void setIndexVersion(int version) {
        this.indexVersion = version;
    }

    public void setEObjectFinder(EObjectFinder finder) {
        this.finder = finder;
    }

    @Override
    public Object getEObject() {
        if (this.eObject != null) {
            return this.eObject;
        }
        CoreArgCheck.isNotNull((Object)this.finder);
        try {
            String uuid = this.getUUID();
            int delimitIndex = uuid.indexOf(58);
            UUID objID = DatatypeConstants.stringToObject(uuid.substring(delimitIndex + 1));
            return this.finder.find(objID);
        }
        catch (Exception e) {
            CoreModelerPlugin.Util.log((Throwable)e);
            return null;
        }
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String path) {
        this.resourcePath = path;
    }

    public void setRecordType(char c) {
        this.recordType = c;
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        CoreArgCheck.isNotNull((Object)propertyName);
        if (this.propValues != null) {
            return this.propValues.get(propertyName);
        }
        return null;
    }

    @Override
    public void setPropertyValue(String propertyName, Object propertyVame) {
        if (propertyName != null && propertyVame != null) {
            if (this.propValues == null) {
                this.propValues = new HashMap();
            }
            this.propValues.put(propertyName, propertyVame);
        }
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractMetadataRecord)) {
            return false;
        }
        AbstractMetadataRecord other = (AbstractMetadataRecord)obj;
        if (this.getRecordType() != other.getRecordType()) {
            return false;
        }
        if (!EquivalenceUtil.areEqual((Object)this.getUUID(), (Object)other.getUUID())) {
            return false;
        }
        if (!EquivalenceUtil.areEqual((Object)this.getParentUUID(), (Object)other.getParentUUID())) {
            return false;
        }
        if (!EquivalenceUtil.areEqual((Object)this.getFullName(), (Object)other.getFullName())) {
            return false;
        }
        return EquivalenceUtil.areEqual((Object)this.getNameInSource(), (Object)other.getNameInSource());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (int)this.recordType);
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.delegate.getFullName()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.delegate.getUUID()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.delegate.getParentUUID()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.delegate.getNameInSource()});
        return myHash;
    }
}

