/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metadata.runtime.impl;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.metadata.runtime.ColumnSetRecord;
import org.teiid.designer.metadata.runtime.ListEntryRecord;
import org.teiid.designer.metadata.runtime.impl.AbstractMetadataRecord;
import org.teiid.designer.metadata.runtime.impl.ListEntryRecordImpl;
import org.teiid.designer.metadata.runtime.impl.MetadataRecordDelegate;

public class ColumnSetRecordImpl
extends AbstractMetadataRecord
implements ColumnSetRecord {
    private static final long serialVersionUID = 1L;
    private List columnIDs;

    public ColumnSetRecordImpl() {
        this(new MetadataRecordDelegate());
    }

    protected ColumnSetRecordImpl(MetadataRecordDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public List getColumnIDs() {
        return this.columnIDs;
    }

    @Override
    public ListEntryRecord[] getColumnIdEntries() {
        ArrayList<ListEntryRecordImpl> entryRecords = new ArrayList<ListEntryRecordImpl>(this.columnIDs.size());
        int i = 0;
        int n = this.columnIDs.size();
        while (i < n) {
            String uuid = (String)this.columnIDs.get(i);
            int position = i + 1;
            entryRecords.add(new ListEntryRecordImpl(uuid, position));
            ++i;
        }
        return entryRecords.toArray(new ListEntryRecord[entryRecords.size()]);
    }

    @Override
    public boolean isAccessPattern() {
        return super.getRecordType() == 'H';
    }

    @Override
    public boolean isIndex() {
        return super.getRecordType() == 'L';
    }

    @Override
    public boolean isPrimaryKey() {
        return super.getRecordType() == 'K';
    }

    @Override
    public boolean isUniqueKey() {
        return super.getRecordType() == 'I';
    }

    @Override
    public boolean isResultSet() {
        return super.getRecordType() == 'C';
    }

    @Override
    public short getType() {
        return this.getKeyTypeForRecordType(this.getRecordType());
    }

    public void setColumnIDs(List list) {
        this.columnIDs = list;
    }

    protected short getKeyTypeForRecordType(char recordType) {
        switch (recordType) {
            case 'I': {
                return 2;
            }
            case 'L': {
                return 5;
            }
            case 'H': {
                return 4;
            }
            case 'K': {
                return 0;
            }
            case 'J': {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid record type, for key" + recordType);
    }
}

