/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metadata.runtime.impl;

import java.util.List;
import org.teiid.designer.metadata.runtime.DatatypeRecord;
import org.teiid.designer.metadata.runtime.impl.AbstractMetadataRecord;
import org.teiid.designer.metadata.runtime.impl.MetadataRecordDelegate;

public class DatatypeRecordImpl
extends AbstractMetadataRecord
implements DatatypeRecord {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_JAVA_CLASS_NAME = "java.lang.Object";
    private int length;
    private int precisionLength;
    private int scale;
    private int radix;
    private boolean isSigned;
    private boolean isAutoIncrement;
    private boolean isCaseSensitive;
    private short type;
    private short searchType;
    private short nullType;
    private String javaClassName;
    private String runtimeTypeName;
    private String datatypeID;
    private String basetypeID;
    private String primitiveTypeID;
    private short varietyType;
    private List varietyProps;

    public DatatypeRecordImpl() {
        this(new MetadataRecordDelegate());
        this.javaClassName = DEFAULT_JAVA_CLASS_NAME;
    }

    protected DatatypeRecordImpl(MetadataRecordDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName() {
        String fullName = super.getFullName();
        int indx = fullName.lastIndexOf("#");
        if (indx > -1) {
            return fullName.substring(indx + 1);
        }
        indx = fullName.lastIndexOf(46);
        if (indx > -1) {
            return fullName.substring(indx + 1);
        }
        return fullName;
    }

    @Override
    public String getModelName() {
        String fullName = super.getFullName();
        int indx = fullName.lastIndexOf("#");
        if (indx > -1) {
            return fullName.substring(0, indx);
        }
        indx = fullName.lastIndexOf(46);
        if (indx > -1) {
            return fullName.substring(0, indx);
        }
        return fullName;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getPrecisionLength() {
        return this.precisionLength;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getRadix() {
        return this.radix;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public short getType() {
        return this.type;
    }

    @Override
    public boolean isBuiltin() {
        return this.getType() == 0;
    }

    @Override
    public short getSearchType() {
        return this.searchType;
    }

    @Override
    public short getNullType() {
        return this.nullType;
    }

    @Override
    public String getJavaClassName() {
        return this.javaClassName;
    }

    @Override
    public String getRuntimeTypeName() {
        return this.runtimeTypeName;
    }

    @Override
    public String getDatatypeID() {
        return this.datatypeID;
    }

    @Override
    public String getBasetypeID() {
        return this.basetypeID;
    }

    @Override
    public String getBasetypeName() {
        int i;
        if (this.basetypeID != null && (i = this.getBasetypeID().lastIndexOf("#")) != -1 && this.getBasetypeID().length() > i + 1) {
            return this.getBasetypeID().substring(i + 1);
        }
        return null;
    }

    @Override
    public String getPrimitiveTypeID() {
        return this.primitiveTypeID;
    }

    @Override
    public short getVarietyType() {
        return this.varietyType;
    }

    @Override
    public List getVarietyProps() {
        return this.varietyProps;
    }

    public void setBasetypeID(String string) {
        this.basetypeID = string;
    }

    public void setPrimitiveTypeID(String string) {
        this.primitiveTypeID = string;
    }

    public void setAutoIncrement(boolean b) {
        this.isAutoIncrement = b;
    }

    public void setCaseSensitive(boolean b) {
        this.isCaseSensitive = b;
    }

    public void setSigned(boolean b) {
        this.isSigned = b;
    }

    public void setJavaClassName(String string) {
        this.javaClassName = string;
    }

    public void setLength(int i) {
        this.length = i;
    }

    public void setNullType(short s) {
        this.nullType = s;
    }

    public void setPrecisionLength(int i) {
        this.precisionLength = i;
    }

    public void setRadix(int i) {
        this.radix = i;
    }

    public void setRuntimeTypeName(String string) {
        this.runtimeTypeName = string;
    }

    public void setScale(int i) {
        this.scale = i;
    }

    public void setSearchType(short s) {
        this.searchType = s;
    }

    public void setType(short s) {
        this.type = s;
    }

    public void setDatatypeID(String string) {
        this.datatypeID = string;
    }

    public void setVarietyProps(List list) {
        this.varietyProps = list;
    }

    public void setVarietyType(short s) {
        this.varietyType = s;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getClass().getSimpleName());
        sb.append(" name=");
        sb.append(this.getName());
        sb.append(", basetype name=");
        sb.append(this.getBasetypeName());
        sb.append(", runtimeType=");
        sb.append(this.getRuntimeTypeName());
        sb.append(", javaClassName=");
        sb.append(this.getJavaClassName());
        sb.append(", ObjectID=");
        sb.append(this.getUUID());
        sb.append(", datatypeID=");
        sb.append(this.getDatatypeID());
        return sb.toString();
    }
}

