/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metadata.runtime.impl;

import java.io.File;
import java.io.InputStream;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.EquivalenceUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.metadata.runtime.FileRecord;
import org.teiid.designer.metadata.runtime.impl.AbstractMetadataRecord;

public class FileRecordImpl
extends AbstractMetadataRecord
implements FileRecord {
    private static final long serialVersionUID = 1L;
    private String pathInVdb;
    private String[] tokens;
    private String[] tokenReplacements;
    private IndexSelector selector;

    @Override
    public String getPathInVdb() {
        return this.pathInVdb;
    }

    @Override
    public boolean getBinary() {
        return this.pathInVdb != null && this.pathInVdb.endsWith("INDEX");
    }

    @Override
    public InputStream getContent() {
        if (this.tokens != null) {
            return this.selector.getFileContent(this.getPathInVdb(), this.tokens, this.tokenReplacements);
        }
        return this.selector.getFileContent(this.getPathInVdb());
    }

    public long getFileLength() {
        return this.selector.getFileSize(this.getPathInVdb());
    }

    public void setPathInVdb(String pathInVdb) {
        this.pathInVdb = pathInVdb;
    }

    @Override
    public String[] getTokens() {
        return this.tokens;
    }

    @Override
    public String[] getTokenReplacements() {
        return this.tokenReplacements;
    }

    @Override
    public void setTokens(String[] tokens) {
        this.tokens = tokens;
    }

    @Override
    public void setTokenReplacements(String[] tokenReplacements) {
        this.tokenReplacements = tokenReplacements;
    }

    @Override
    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    @Override
    public FileRecord getFileRecord() {
        return this;
    }

    @Override
    public String getModelName() {
        if (this.isModelFile()) {
            return FileUtils.getBaseFileNameWithoutExtension((String)this.pathInVdb);
        }
        return null;
    }

    @Override
    public boolean isIndexFile() {
        return this.pathInVdb != null && this.pathInVdb.endsWith("INDEX");
    }

    @Override
    public boolean isModelFile() {
        if (this.pathInVdb != null) {
            File fileInVdb = this.selector.getFile(this.pathInVdb);
            return ModelFileUtil.isModelFile(fileInVdb);
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FileRecord other = (FileRecord)obj;
        if (!EquivalenceUtil.areEqual((Object)this.getPathInVdb(), (Object)other.getPathInVdb())) {
            return false;
        }
        if (!EquivalenceUtil.areEqual((Object)this.getTokens(), (Object)other.getTokens())) {
            return false;
        }
        return EquivalenceUtil.areEqual((Object)this.getTokenReplacements(), (Object)other.getTokenReplacements());
    }

    @Override
    public int hashCode() {
        int myHash = 0;
        if (this.pathInVdb != null) {
            myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.pathInVdb});
        }
        if (this.tokens != null) {
            myHash = HashCodeUtil.hashCode((int)myHash, (Object[])this.tokens);
        }
        if (this.tokenReplacements != null) {
            myHash = HashCodeUtil.hashCode((int)myHash, (Object[])this.tokenReplacements);
        }
        return myHash;
    }

    @Override
    public String toString() {
        return this.getPathInVdb();
    }
}

